/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.example.cluster;

import io.zeebe.client.ZeebeClient;
import io.zeebe.client.ZeebeClientBuilder;
import io.zeebe.client.api.response.Topology;

public final class TopologyViewer {
    public static void main(String[] args) {
        ZeebeClientBuilder clientBuilder;
        String contactPoint;
        String defaultAddress = "localhost:26500";
        String envVarAddress = System.getenv("ZEEBE_ADDRESS");
        if (envVarAddress != null) {
            contactPoint = envVarAddress;
            clientBuilder = ZeebeClient.newClientBuilder().gatewayAddress(envVarAddress);
        } else {
            contactPoint = "localhost:26500";
            clientBuilder = ZeebeClient.newClientBuilder().gatewayAddress("localhost:26500").usePlaintext();
        }
        try (ZeebeClient client = clientBuilder.build();){
            System.out.println("Requesting topology with initial contact point " + contactPoint);
            Topology topology = (Topology)client.newTopologyRequest().send().join();
            System.out.println("Topology:");
            topology.getBrokers().forEach(b -> {
                System.out.println("    " + b.getAddress());
                b.getPartitions().forEach(p -> System.out.println("      " + p.getPartitionId() + " - " + p.getRole()));
            });
            System.out.println("Done.");
        }
    }
}

