/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.worker;

import io.zeebe.client.api.worker.BackoffSupplier;
import io.zeebe.client.api.worker.ExponentialBackoffBuilder;
import io.zeebe.client.impl.worker.ExponentialBackoff;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public final class ExponentialBackoffBuilderImpl
implements ExponentialBackoffBuilder {
    private static final long DEFAULT_MAX_DELAY = TimeUnit.SECONDS.toMillis(5L);
    private static final long DEFAULT_MIN_DELAY = TimeUnit.MILLISECONDS.toMillis(50L);
    private static final double DEFAULT_MULTIPLIER = 1.6;
    private static final double DEFAULT_JITTER = 0.1;
    private static final Random DEFAULT_RANDOM = new Random();
    private long maxDelay = DEFAULT_MAX_DELAY;
    private long minDelay = DEFAULT_MIN_DELAY;
    private double backoffFactor = 1.6;
    private double jitterFactor = 0.1;
    private Random random = DEFAULT_RANDOM;

    @Override
    public ExponentialBackoffBuilder maxDelay(long maxDelay) {
        this.maxDelay = maxDelay;
        return this;
    }

    @Override
    public ExponentialBackoffBuilder minDelay(long minDelay) {
        this.minDelay = minDelay;
        return this;
    }

    @Override
    public ExponentialBackoffBuilder backoffFactor(double backoffFactor) {
        this.backoffFactor = backoffFactor;
        return this;
    }

    @Override
    public ExponentialBackoffBuilder jitterFactor(double jitterFactor) {
        this.jitterFactor = jitterFactor;
        return this;
    }

    @Override
    public ExponentialBackoffBuilder random(Random random) {
        this.random = random;
        return this;
    }

    @Override
    public BackoffSupplier build() {
        return new ExponentialBackoff(this.maxDelay, this.minDelay, this.backoffFactor, this.jitterFactor, this.random);
    }
}

