/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.response;

import io.zeebe.client.api.response.Process;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.Objects;

public final class ProcessImpl
implements Process {
    private final long processDefinitionKey;
    private final String bpmnProcessId;
    private final int version;
    private final String resourceName;

    public ProcessImpl(GatewayOuterClass.ProcessMetadata process) {
        this(process.getProcessDefinitionKey(), process.getBpmnProcessId(), process.getVersion(), process.getResourceName());
    }

    public ProcessImpl(long processDefinitionKey, String bpmnProcessId, int version, String resourceName) {
        this.processDefinitionKey = processDefinitionKey;
        this.bpmnProcessId = bpmnProcessId;
        this.version = version;
        this.resourceName = resourceName;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    public int hashCode() {
        return Objects.hash(this.processDefinitionKey, this.bpmnProcessId, this.version, this.resourceName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessImpl process = (ProcessImpl)o;
        return this.processDefinitionKey == process.processDefinitionKey && this.version == process.version && Objects.equals(this.bpmnProcessId, process.bpmnProcessId) && Objects.equals(this.resourceName, process.resourceName);
    }

    public String toString() {
        return "ProcessImpl{processDefinitionKey=" + this.processDefinitionKey + ", bpmnProcessId='" + this.bpmnProcessId + '\'' + ", version=" + this.version + ", resourceName='" + this.resourceName + '\'' + '}';
    }
}

