/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.oauth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.zeebe.client.impl.ZeebeClientCredentials;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class OAuthCredentialsCache {
    private static final String KEY_AUTH = "auth";
    private static final String KEY_CREDENTIALS = "credentials";
    private static final TypeReference<Map<String, OAuthCachedCredentials>> TYPE_REFERENCE = new TypeReference<Map<String, OAuthCachedCredentials>>(){};
    private static final ObjectMapper MAPPER = new ObjectMapper(new YAMLFactory());
    private final Map<String, OAuthCachedCredentials> audiences;
    private final File cacheFile;

    public OAuthCredentialsCache(File cacheFile) {
        this.cacheFile = cacheFile;
        this.audiences = new HashMap<String, OAuthCachedCredentials>();
    }

    public OAuthCredentialsCache readCache() throws IOException {
        if (!this.cacheFile.exists() || this.cacheFile.length() == 0L) {
            return this;
        }
        Map<String, OAuthCachedCredentials> cache = MAPPER.readValue(this.cacheFile, TYPE_REFERENCE);
        this.audiences.clear();
        this.audiences.putAll(cache);
        return this;
    }

    public void writeCache() throws IOException {
        HashMap<String, Map<String, OAuthCachedCredentials>> cache = new HashMap<String, Map<String, OAuthCachedCredentials>>(this.audiences.size());
        for (Map.Entry<String, OAuthCachedCredentials> audience : this.audiences.entrySet()) {
            cache.put(audience.getKey(), Collections.singletonMap(KEY_AUTH, audience.getValue()));
        }
        this.ensureCacheFileExists();
        MAPPER.writer().writeValue(this.cacheFile, cache);
    }

    public Optional<ZeebeClientCredentials> get(String endpoint) {
        return Optional.ofNullable(this.audiences.get(endpoint)).map(rec$ -> ((OAuthCachedCredentials)rec$).getCredentials());
    }

    public OAuthCredentialsCache put(String endpoint, ZeebeClientCredentials credentials) {
        this.audiences.put(endpoint, new OAuthCachedCredentials(credentials));
        return this;
    }

    public int size() {
        return this.audiences.size();
    }

    private void ensureCacheFileExists() throws IOException {
        if (this.cacheFile.exists()) {
            return;
        }
        Files.createDirectories(this.cacheFile.getParentFile().toPath(), new FileAttribute[0]);
        Files.createFile(this.cacheFile.toPath(), new FileAttribute[0]);
    }

    private static final class OAuthCachedCredentials {
        private final ZeebeClientCredentials credentials;

        @JsonCreator
        private OAuthCachedCredentials(@JsonProperty(value="auth") Map<String, ZeebeClientCredentials> auth) {
            this(auth.get(OAuthCredentialsCache.KEY_CREDENTIALS));
        }

        private OAuthCachedCredentials(ZeebeClientCredentials credentials) {
            this.credentials = credentials;
        }

        @JsonGetter(value="credentials")
        private ZeebeClientCredentials getCredentials() {
            return this.credentials;
        }
    }
}

