/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.command;

import io.grpc.stub.StreamObserver;
import io.zeebe.client.ZeebeClientConfiguration;
import io.zeebe.client.api.JsonMapper;
import io.zeebe.client.api.ZeebeFuture;
import io.zeebe.client.api.command.FinalCommandStep;
import io.zeebe.client.api.command.PublishMessageCommandStep1;
import io.zeebe.client.api.response.PublishMessageResponse;
import io.zeebe.client.impl.RetriableClientFutureImpl;
import io.zeebe.client.impl.command.CommandWithVariables;
import io.zeebe.client.impl.response.PublishMessageResponseImpl;
import io.zeebe.gateway.protocol.GatewayGrpc;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class PublishMessageCommandImpl
extends CommandWithVariables<PublishMessageCommandImpl>
implements PublishMessageCommandStep1,
PublishMessageCommandStep1.PublishMessageCommandStep2,
PublishMessageCommandStep1.PublishMessageCommandStep3 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final Predicate<Throwable> retryPredicate;
    private final GatewayOuterClass.PublishMessageRequest.Builder builder;
    private Duration requestTimeout;

    public PublishMessageCommandImpl(GatewayGrpc.GatewayStub asyncStub, ZeebeClientConfiguration configuration, JsonMapper jsonMapper, Predicate<Throwable> retryPredicate) {
        super(jsonMapper);
        this.asyncStub = asyncStub;
        this.retryPredicate = retryPredicate;
        this.builder = GatewayOuterClass.PublishMessageRequest.newBuilder();
        this.requestTimeout = configuration.getDefaultRequestTimeout();
        this.builder.setTimeToLive(configuration.getDefaultMessageTimeToLive().toMillis());
    }

    @Override
    protected PublishMessageCommandImpl setVariablesInternal(String variables) {
        this.builder.setVariables(variables);
        return this;
    }

    @Override
    public PublishMessageCommandStep1.PublishMessageCommandStep3 messageId(String messageId) {
        this.builder.setMessageId(messageId);
        return this;
    }

    @Override
    public PublishMessageCommandStep1.PublishMessageCommandStep3 timeToLive(Duration timeToLive) {
        this.builder.setTimeToLive(timeToLive.toMillis());
        return this;
    }

    @Override
    public PublishMessageCommandStep1.PublishMessageCommandStep3 correlationKey(String correlationKey) {
        this.builder.setCorrelationKey(correlationKey);
        return this;
    }

    @Override
    public PublishMessageCommandStep1.PublishMessageCommandStep2 messageName(String messageName) {
        this.builder.setName(messageName);
        return this;
    }

    @Override
    public FinalCommandStep<PublishMessageResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<PublishMessageResponse> send() {
        GatewayOuterClass.PublishMessageRequest request = this.builder.build();
        RetriableClientFutureImpl<PublishMessageResponse, GatewayOuterClass.PublishMessageResponse> future = new RetriableClientFutureImpl<PublishMessageResponse, GatewayOuterClass.PublishMessageResponse>(PublishMessageResponseImpl::new, this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.PublishMessageResponse>)streamObserver));
        this.send(request, future);
        return future;
    }

    private void send(GatewayOuterClass.PublishMessageRequest request, StreamObserver<GatewayOuterClass.PublishMessageResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).publishMessage(request, streamObserver);
    }
}

