/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.command;

import io.grpc.stub.StreamObserver;
import io.zeebe.client.api.ZeebeFuture;
import io.zeebe.client.api.command.FinalCommandStep;
import io.zeebe.client.api.command.UpdateRetriesJobCommandStep1;
import io.zeebe.client.api.response.UpdateRetriesJobResponse;
import io.zeebe.client.impl.RetriableClientFutureImpl;
import io.zeebe.gateway.protocol.GatewayGrpc;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class JobUpdateRetriesCommandImpl
implements UpdateRetriesJobCommandStep1,
UpdateRetriesJobCommandStep1.UpdateRetriesJobCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.UpdateJobRetriesRequest.Builder builder;
    private final Predicate<Throwable> retryPredicate;
    private Duration requestTimeout;

    public JobUpdateRetriesCommandImpl(GatewayGrpc.GatewayStub asyncStub, long jobKey, Duration requestTimeout, Predicate<Throwable> retryPredicate) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.builder = GatewayOuterClass.UpdateJobRetriesRequest.newBuilder();
        this.builder.setJobKey(jobKey);
    }

    @Override
    public UpdateRetriesJobCommandStep1.UpdateRetriesJobCommandStep2 retries(int retries) {
        this.builder.setRetries(retries);
        return this;
    }

    @Override
    public FinalCommandStep<UpdateRetriesJobResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<UpdateRetriesJobResponse> send() {
        GatewayOuterClass.UpdateJobRetriesRequest request = this.builder.build();
        RetriableClientFutureImpl future = new RetriableClientFutureImpl(this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.UpdateJobRetriesResponse>)streamObserver));
        this.send(request, future);
        return future;
    }

    private void send(GatewayOuterClass.UpdateJobRetriesRequest request, StreamObserver<GatewayOuterClass.UpdateJobRetriesResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).updateJobRetries(request, streamObserver);
    }
}

