/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl;

import io.grpc.CallCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import io.zeebe.client.CredentialsProvider;
import io.zeebe.client.ZeebeClient;
import io.zeebe.client.ZeebeClientConfiguration;
import io.zeebe.client.api.JsonMapper;
import io.zeebe.client.api.command.ActivateJobsCommandStep1;
import io.zeebe.client.api.command.CancelProcessInstanceCommandStep1;
import io.zeebe.client.api.command.ClientException;
import io.zeebe.client.api.command.CompleteJobCommandStep1;
import io.zeebe.client.api.command.CreateProcessInstanceCommandStep1;
import io.zeebe.client.api.command.DeployProcessCommandStep1;
import io.zeebe.client.api.command.FailJobCommandStep1;
import io.zeebe.client.api.command.PublishMessageCommandStep1;
import io.zeebe.client.api.command.ResolveIncidentCommandStep1;
import io.zeebe.client.api.command.SetVariablesCommandStep1;
import io.zeebe.client.api.command.ThrowErrorCommandStep1;
import io.zeebe.client.api.command.TopologyRequestStep1;
import io.zeebe.client.api.command.UpdateRetriesJobCommandStep1;
import io.zeebe.client.api.worker.JobClient;
import io.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.zeebe.client.impl.NoopCredentialsProvider;
import io.zeebe.client.impl.ZeebeCallCredentials;
import io.zeebe.client.impl.command.ActivateJobsCommandImpl;
import io.zeebe.client.impl.command.CancelProcessInstanceCommandImpl;
import io.zeebe.client.impl.command.CreateProcessInstanceCommandImpl;
import io.zeebe.client.impl.command.DeployProcessCommandImpl;
import io.zeebe.client.impl.command.JobUpdateRetriesCommandImpl;
import io.zeebe.client.impl.command.PublishMessageCommandImpl;
import io.zeebe.client.impl.command.ResolveIncidentCommandImpl;
import io.zeebe.client.impl.command.SetVariablesCommandImpl;
import io.zeebe.client.impl.command.TopologyRequestImpl;
import io.zeebe.client.impl.util.VersionUtil;
import io.zeebe.client.impl.worker.JobClientImpl;
import io.zeebe.client.impl.worker.JobWorkerBuilderImpl;
import io.zeebe.gateway.protocol.GatewayGrpc;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class ZeebeClientImpl
implements ZeebeClient {
    private final ZeebeClientConfiguration config;
    private final JsonMapper jsonMapper;
    private final GatewayGrpc.GatewayStub asyncStub;
    private final ManagedChannel channel;
    private final ScheduledExecutorService executorService;
    private final List<Closeable> closeables = new CopyOnWriteArrayList<Closeable>();
    private final JobClient jobClient;
    private final CredentialsProvider credentialsProvider;

    public ZeebeClientImpl(ZeebeClientConfiguration configuration) {
        this(configuration, ZeebeClientImpl.buildChannel(configuration));
    }

    public ZeebeClientImpl(ZeebeClientConfiguration configuration, ManagedChannel channel) {
        this(configuration, channel, ZeebeClientImpl.buildGatewayStub(channel, configuration));
    }

    public ZeebeClientImpl(ZeebeClientConfiguration configuration, ManagedChannel channel, GatewayGrpc.GatewayStub gatewayStub) {
        this(configuration, channel, gatewayStub, ZeebeClientImpl.buildExecutorService(configuration));
    }

    public ZeebeClientImpl(ZeebeClientConfiguration config, ManagedChannel channel, GatewayGrpc.GatewayStub gatewayStub, ScheduledExecutorService executorService) {
        this.config = config;
        this.jsonMapper = config.getJsonMapper();
        this.channel = channel;
        this.asyncStub = gatewayStub;
        this.executorService = executorService;
        this.credentialsProvider = config.getCredentialsProvider() != null ? config.getCredentialsProvider() : new NoopCredentialsProvider();
        this.jobClient = this.newJobClient();
    }

    public static ManagedChannel buildChannel(ZeebeClientConfiguration config) {
        URI address;
        try {
            address = new URI("zb://" + config.getGatewayAddress());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to parse broker contact point", e);
        }
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress(address.getHost(), address.getPort());
        ZeebeClientImpl.configureConnectionSecurity(config, channelBuilder);
        channelBuilder.keepAliveTime(config.getKeepAlive().toMillis(), TimeUnit.MILLISECONDS);
        channelBuilder.userAgent("zeebe-client-java/" + VersionUtil.getVersion());
        return channelBuilder.build();
    }

    private static CallCredentials buildCallCredentials(ZeebeClientConfiguration config) {
        CredentialsProvider customCredentialsProvider = config.getCredentialsProvider();
        if (customCredentialsProvider == null) {
            return null;
        }
        return new ZeebeCallCredentials(customCredentialsProvider);
    }

    private static void configureConnectionSecurity(ZeebeClientConfiguration config, NettyChannelBuilder channelBuilder) {
        if (!config.isPlaintextConnectionEnabled()) {
            String certificatePath = config.getCaCertificatePath();
            SslContext sslContext = null;
            if (certificatePath != null) {
                if (certificatePath.isEmpty()) {
                    throw new IllegalArgumentException("Expected valid certificate path but found empty path instead.");
                }
                try (FileInputStream certInputStream = new FileInputStream(certificatePath);){
                    sslContext = GrpcSslContexts.forClient().trustManager(certInputStream).build();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            channelBuilder.useTransportSecurity().sslContext(sslContext);
        } else {
            channelBuilder.usePlaintext();
        }
    }

    public static GatewayGrpc.GatewayStub buildGatewayStub(ManagedChannel channel, ZeebeClientConfiguration config) {
        CallCredentials credentials = ZeebeClientImpl.buildCallCredentials(config);
        GatewayGrpc.GatewayStub gatewayStub = (GatewayGrpc.GatewayStub)GatewayGrpc.newStub(channel).withCallCredentials(credentials);
        if (!config.getInterceptors().isEmpty()) {
            return (GatewayGrpc.GatewayStub)gatewayStub.withInterceptors(config.getInterceptors().toArray(new ClientInterceptor[0]));
        }
        return gatewayStub;
    }

    private static ScheduledExecutorService buildExecutorService(ZeebeClientConfiguration configuration) {
        int threadCount = configuration.getNumJobWorkerExecutionThreads();
        return Executors.newScheduledThreadPool(threadCount);
    }

    @Override
    public TopologyRequestStep1 newTopologyRequest() {
        return new TopologyRequestImpl(this.asyncStub, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest);
    }

    @Override
    public ZeebeClientConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void close() {
        this.closeables.forEach(c -> {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        this.executorService.shutdownNow();
        try {
            if (!this.executorService.awaitTermination(15L, TimeUnit.SECONDS)) {
                throw new ClientException("Timed out awaiting termination of job worker executor after 15 seconds");
            }
        }
        catch (InterruptedException e) {
            throw new ClientException("Unexpected interrupted awaiting termination of job worker executor", e);
        }
        this.channel.shutdownNow();
        try {
            if (!this.channel.awaitTermination(15L, TimeUnit.SECONDS)) {
                throw new ClientException("Timed out awaiting termination of in-flight request channel after 15 seconds");
            }
        }
        catch (InterruptedException e) {
            throw new ClientException("Unexpectedly interrupted awaiting termination of in-flight request channel", e);
        }
    }

    @Override
    public DeployProcessCommandStep1 newDeployCommand() {
        return new DeployProcessCommandImpl(this.asyncStub, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest);
    }

    @Override
    public CreateProcessInstanceCommandStep1 newCreateInstanceCommand() {
        return new CreateProcessInstanceCommandImpl(this.asyncStub, this.jsonMapper, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest);
    }

    @Override
    public CancelProcessInstanceCommandStep1 newCancelInstanceCommand(long processInstanceKey) {
        return new CancelProcessInstanceCommandImpl(this.asyncStub, processInstanceKey, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest);
    }

    @Override
    public SetVariablesCommandStep1 newSetVariablesCommand(long elementInstanceKey) {
        return new SetVariablesCommandImpl(this.asyncStub, this.jsonMapper, elementInstanceKey, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest);
    }

    @Override
    public PublishMessageCommandStep1 newPublishMessageCommand() {
        return new PublishMessageCommandImpl(this.asyncStub, this.config, this.jsonMapper, this.credentialsProvider::shouldRetryRequest);
    }

    @Override
    public ResolveIncidentCommandStep1 newResolveIncidentCommand(long incidentKey) {
        return new ResolveIncidentCommandImpl(this.asyncStub, incidentKey, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest);
    }

    @Override
    public UpdateRetriesJobCommandStep1 newUpdateRetriesCommand(long jobKey) {
        return new JobUpdateRetriesCommandImpl(this.asyncStub, jobKey, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest);
    }

    @Override
    public JobWorkerBuilderStep1 newWorker() {
        return new JobWorkerBuilderImpl(this.config, this.asyncStub, this.jobClient, this.jsonMapper, this.executorService, this.closeables, this.credentialsProvider::shouldRetryRequest);
    }

    @Override
    public ActivateJobsCommandStep1 newActivateJobsCommand() {
        return new ActivateJobsCommandImpl(this.asyncStub, this.config, this.jsonMapper, this.credentialsProvider::shouldRetryRequest);
    }

    private JobClient newJobClient() {
        return new JobClientImpl(this.asyncStub, this.config, this.jsonMapper, this.credentialsProvider::shouldRetryRequest);
    }

    @Override
    public CompleteJobCommandStep1 newCompleteCommand(long jobKey) {
        return this.jobClient.newCompleteCommand(jobKey);
    }

    @Override
    public FailJobCommandStep1 newFailCommand(long jobKey) {
        return this.jobClient.newFailCommand(jobKey);
    }

    @Override
    public ThrowErrorCommandStep1 newThrowErrorCommand(long jobKey) {
        return this.jobClient.newThrowErrorCommand(jobKey);
    }
}

