/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.zeebe.client.api.ZeebeFuture;
import io.zeebe.client.api.command.ClientException;
import io.zeebe.client.api.command.ClientStatusException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class ZeebeClientFutureImpl<ClientResponse, BrokerResponse>
extends CompletableFuture<ClientResponse>
implements ZeebeFuture<ClientResponse>,
StreamObserver<BrokerResponse> {
    private final Function<BrokerResponse, ClientResponse> responseMapper;

    public ZeebeClientFutureImpl() {
        this(brokerResponse -> null);
    }

    public ZeebeClientFutureImpl(Function<BrokerResponse, ClientResponse> responseMapper) {
        this.responseMapper = responseMapper;
    }

    @Override
    public ClientResponse join() {
        try {
            return (ClientResponse)this.get();
        }
        catch (ExecutionException e) {
            throw this.transformExecutionException(e);
        }
        catch (InterruptedException e) {
            throw new ClientException("Unexpectedly interrupted awaiting client response", e);
        }
    }

    @Override
    public ClientResponse join(long timeout, TimeUnit unit) {
        try {
            return (ClientResponse)this.get(timeout, unit);
        }
        catch (ExecutionException e) {
            throw this.transformExecutionException(e);
        }
        catch (InterruptedException e) {
            throw new ClientException("Unexpectedly interrupted awaiting client response", e);
        }
        catch (TimeoutException e) {
            throw new ClientException("Timed out waiting on client response", e);
        }
    }

    @Override
    public void onNext(BrokerResponse brokerResponse) {
        try {
            this.complete(this.responseMapper.apply(brokerResponse));
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        this.completeExceptionally(throwable);
    }

    @Override
    public void onCompleted() {
    }

    private RuntimeException transformExecutionException(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof StatusRuntimeException) {
            Status status = ((StatusRuntimeException)cause).getStatus();
            throw new ClientStatusException(status, (Throwable)e);
        }
        throw new ClientException(e);
    }
}

