/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public final class ZeebeClientCredentials {
    @JsonAlias(value={"accesstoken", "access_token"})
    private String accessToken;
    private ZonedDateTime expiry;
    @JsonAlias(value={"tokentype", "token_type"})
    private String tokenType;

    public ZeebeClientCredentials() {
    }

    public ZeebeClientCredentials(String accessToken, ZonedDateTime expiry, String tokenType) {
        this.accessToken = accessToken;
        this.expiry = expiry;
        this.tokenType = tokenType;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    @JsonSetter(value="expiry")
    public void setExpiry(String expiry) {
        this.expiry = ZonedDateTime.parse(expiry);
    }

    @JsonSetter(value="expires_in")
    public void setExpiresIn(String expiresIn) {
        this.expiry = ZonedDateTime.now().plusSeconds(Long.parseLong(expiresIn));
    }

    @JsonGetter(value="expiry")
    public String getExpiry() {
        return this.expiry.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    @JsonIgnore
    public boolean isValid() {
        return this.expiry.toInstant().isAfter(Instant.now());
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.expiry, this.tokenType);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        ZeebeClientCredentials other = (ZeebeClientCredentials)o;
        return this.accessToken.equals(other.accessToken) && this.tokenType.equals(other.tokenType);
    }
}

