/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl;

import io.grpc.stub.StreamObserver;
import io.zeebe.client.impl.ZeebeStreamingClientFutureImpl;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class RetriableStreamingFutureImpl<C, B>
extends ZeebeStreamingClientFutureImpl<C, B> {
    private final Predicate<Throwable> retryPredicate;
    private final Consumer<StreamObserver<B>> retryAction;

    public RetriableStreamingFutureImpl(C clientResponse, Consumer<B> collector, Predicate<Throwable> retryPredicate, Consumer<StreamObserver<B>> retryAction) {
        super(clientResponse, collector);
        Objects.requireNonNull(retryPredicate, "Expected to have non-null retry predicate.");
        Objects.requireNonNull(retryAction, "Expected to have non-null retry action.");
        this.retryPredicate = retryPredicate;
        this.retryAction = retryAction;
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.retryPredicate.test(throwable)) {
            this.retryAction.accept(this);
        } else {
            super.onError(throwable);
        }
    }
}

