/*
 * Copyright © 2017 camunda services GmbH (info@camunda.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.zeebe.protocol.record.value.deployment;

/** Represents a single deployment resource. */
public interface DeploymentResource {

  /** @return the resource contents */
  byte[] getResource();

  /**
   * @return the type of the resource
   * @deprecated As of release 1.0, YAML support was removed and BPMN is the only supported resource
   *     type. The method was kept to not break exporters relying on this method, e.g. hazelcast,
   *     elastic (operate).
   */
  @Deprecated
  ResourceType getResourceType();

  /** @return the name of the resource */
  String getResourceName();
}
