/* Generated SBE (Simple Binary Encoding) message codec. */
package io.zeebe.protocol.record;

public enum RejectionType
{
    INVALID_ARGUMENT((short)0),

    NOT_FOUND((short)1),

    ALREADY_EXISTS((short)2),

    INVALID_STATE((short)3),

    PROCESSING_ERROR((short)4),

    /**
     * To be used to represent a unknown value from a later version.
     */
    SBE_UNKNOWN((short)255),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL((short)255);

    private final short value;

    RejectionType(final short value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public short value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static RejectionType get(final short value)
    {
        switch (value)
        {
            case 0: return INVALID_ARGUMENT;
            case 1: return NOT_FOUND;
            case 2: return ALREADY_EXISTS;
            case 3: return INVALID_STATE;
            case 4: return PROCESSING_ERROR;
            case 255: return NULL_VAL;
        }

        return SBE_UNKNOWN;
    }
}
