/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.record.intent;

import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.WorkflowInstanceRelatedIntent;

public enum WorkflowInstanceIntent implements WorkflowInstanceRelatedIntent
{
    CANCEL(0, false),
    SEQUENCE_FLOW_TAKEN(1),
    ELEMENT_ACTIVATING(2),
    ELEMENT_ACTIVATED(3),
    ELEMENT_COMPLETING(4),
    ELEMENT_COMPLETED(5),
    ELEMENT_TERMINATING(6),
    ELEMENT_TERMINATED(7),
    EVENT_OCCURRED(8);

    private final short value;
    private final boolean shouldBlacklist;

    private WorkflowInstanceIntent(short value) {
        this(value, true);
    }

    private WorkflowInstanceIntent(short value, boolean shouldBlacklist) {
        this.value = value;
        this.shouldBlacklist = shouldBlacklist;
    }

    public short getIntent() {
        return this.value;
    }

    public static Intent from(short value) {
        switch (value) {
            case 0: {
                return CANCEL;
            }
            case 1: {
                return SEQUENCE_FLOW_TAKEN;
            }
            case 2: {
                return ELEMENT_ACTIVATING;
            }
            case 3: {
                return ELEMENT_ACTIVATED;
            }
            case 4: {
                return ELEMENT_COMPLETING;
            }
            case 5: {
                return ELEMENT_COMPLETED;
            }
            case 6: {
                return ELEMENT_TERMINATING;
            }
            case 7: {
                return ELEMENT_TERMINATED;
            }
            case 8: {
                return EVENT_OCCURRED;
            }
        }
        return Intent.UNKNOWN;
    }

    @Override
    public short value() {
        return this.value;
    }

    @Override
    public boolean shouldBlacklistInstanceOnError() {
        return this.shouldBlacklist;
    }
}

