/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.record;

import io.zeebe.protocol.record.VarDataEncodingDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.CompositeEncoderFlyweight;

public class VarDataEncodingEncoder
implements CompositeEncoderFlyweight {
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 1;
    public static final int ENCODED_LENGTH = -1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private MutableDirectBuffer buffer;

    public VarDataEncodingEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return -1;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public static int lengthEncodingOffset() {
        return 0;
    }

    public static int lengthEncodingLength() {
        return 4;
    }

    public static long lengthNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long lengthMinValue() {
        return 0L;
    }

    public static long lengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public VarDataEncodingEncoder length(long value) {
        this.buffer.putInt(this.offset + 0, (int)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int varDataEncodingOffset() {
        return 4;
    }

    public static int varDataEncodingLength() {
        return -1;
    }

    public static short varDataNullValue() {
        return 255;
    }

    public static short varDataMinValue() {
        return 0;
    }

    public static short varDataMaxValue() {
        return 254;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        VarDataEncodingDecoder writer = new VarDataEncodingDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset);
        return writer.appendTo(builder);
    }
}

