/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.record;

import io.zeebe.protocol.record.MetaAttribute;
import io.zeebe.protocol.record.PartitionRole;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public class BrokerInfoDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 16;
    public static final int TEMPLATE_ID = 201;
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final BrokerInfoDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;
    private final AddressesDecoder addresses = new AddressesDecoder(this);
    private final PartitionRolesDecoder partitionRoles = new PartitionRolesDecoder(this);

    public int sbeBlockLength() {
        return 16;
    }

    public int sbeTemplateId() {
        return 201;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public BrokerInfoDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int nodeIdId() {
        return 1;
    }

    public static int nodeIdSinceVersion() {
        return 0;
    }

    public static int nodeIdEncodingOffset() {
        return 0;
    }

    public static int nodeIdEncodingLength() {
        return 4;
    }

    public static String nodeIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int nodeIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int nodeIdMinValue() {
        return -2147483647;
    }

    public static int nodeIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int nodeId() {
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int partitionsCountId() {
        return 2;
    }

    public static int partitionsCountSinceVersion() {
        return 0;
    }

    public static int partitionsCountEncodingOffset() {
        return 4;
    }

    public static int partitionsCountEncodingLength() {
        return 4;
    }

    public static String partitionsCountMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int partitionsCountNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int partitionsCountMinValue() {
        return -2147483647;
    }

    public static int partitionsCountMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int partitionsCount() {
        return this.buffer.getInt(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int clusterSizeId() {
        return 3;
    }

    public static int clusterSizeSinceVersion() {
        return 0;
    }

    public static int clusterSizeEncodingOffset() {
        return 8;
    }

    public static int clusterSizeEncodingLength() {
        return 4;
    }

    public static String clusterSizeMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int clusterSizeNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int clusterSizeMinValue() {
        return -2147483647;
    }

    public static int clusterSizeMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int clusterSize() {
        return this.buffer.getInt(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int replicationFactorId() {
        return 4;
    }

    public static int replicationFactorSinceVersion() {
        return 0;
    }

    public static int replicationFactorEncodingOffset() {
        return 12;
    }

    public static int replicationFactorEncodingLength() {
        return 4;
    }

    public static String replicationFactorMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int replicationFactorNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int replicationFactorMinValue() {
        return -2147483647;
    }

    public static int replicationFactorMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int replicationFactor() {
        return this.buffer.getInt(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public static long addressesDecoderId() {
        return 5L;
    }

    public static int addressesDecoderSinceVersion() {
        return 0;
    }

    public AddressesDecoder addresses() {
        this.addresses.wrap(this.buffer);
        return this.addresses;
    }

    public static long partitionRolesDecoderId() {
        return 8L;
    }

    public static int partitionRolesDecoderSinceVersion() {
        return 0;
    }

    public PartitionRolesDecoder partitionRoles() {
        this.partitionRoles.wrap(this.buffer);
        return this.partitionRoles;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[BrokerInfo](sbeTemplateId=");
        builder.append(201);
        builder.append("|sbeSchemaId=");
        builder.append(0);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 1) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(1);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 16) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(16);
        builder.append("):");
        builder.append("nodeId=");
        builder.append(this.nodeId());
        builder.append('|');
        builder.append("partitionsCount=");
        builder.append(this.partitionsCount());
        builder.append('|');
        builder.append("clusterSize=");
        builder.append(this.clusterSize());
        builder.append('|');
        builder.append("replicationFactor=");
        builder.append(this.replicationFactor());
        builder.append('|');
        builder.append("addresses=[");
        AddressesDecoder addresses = this.addresses();
        if (addresses.count() > 0) {
            while (addresses.hasNext()) {
                addresses.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("partitionRoles=[");
        PartitionRolesDecoder partitionRoles = this.partitionRoles();
        if (partitionRoles.count() > 0) {
            while (partitionRoles.hasNext()) {
                partitionRoles.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        this.limit(originalLimit);
        return builder;
    }

    public static class PartitionRolesDecoder
    implements Iterable<PartitionRolesDecoder>,
    Iterator<PartitionRolesDecoder> {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        PartitionRolesDecoder(BrokerInfoDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = -1;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 5;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<PartitionRolesDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.count;
        }

        @Override
        public PartitionRolesDecoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int partitionIdId() {
            return 9;
        }

        public static int partitionIdSinceVersion() {
            return 0;
        }

        public static int partitionIdEncodingOffset() {
            return 0;
        }

        public static int partitionIdEncodingLength() {
            return 4;
        }

        public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "";
                }
                case TIME_UNIT: {
                    return "";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
                case PRESENCE: {
                    return "required";
                }
            }
            return "";
        }

        public static int partitionIdNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int partitionIdMinValue() {
            return -2147483647;
        }

        public static int partitionIdMaxValue() {
            return Integer.MAX_VALUE;
        }

        public int partitionId() {
            return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public static int roleId() {
            return 10;
        }

        public static int roleSinceVersion() {
            return 0;
        }

        public static int roleEncodingOffset() {
            return 4;
        }

        public static int roleEncodingLength() {
            return 1;
        }

        public static String roleMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "";
                }
                case TIME_UNIT: {
                    return "";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
                case PRESENCE: {
                    return "required";
                }
            }
            return "";
        }

        public PartitionRole role() {
            return PartitionRole.get((short)(this.buffer.getByte(this.offset + 4) & 0xFF));
        }

        public String toString() {
            return this.appendTo(new StringBuilder(100)).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            builder.append('(');
            builder.append("partitionId=");
            builder.append(this.partitionId());
            builder.append('|');
            builder.append("role=");
            builder.append((Object)this.role());
            builder.append(')');
            return builder;
        }
    }

    public static class AddressesDecoder
    implements Iterable<AddressesDecoder>,
    Iterator<AddressesDecoder> {
        public static final int HEADER_SIZE = 3;
        private final BrokerInfoDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        AddressesDecoder(BrokerInfoDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = -1;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 0;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<AddressesDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.count;
        }

        @Override
        public AddressesDecoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int apiNameId() {
            return 6;
        }

        public static int apiNameSinceVersion() {
            return 0;
        }

        public static String apiNameCharacterEncoding() {
            return "UTF-8";
        }

        public static String apiNameMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
                case PRESENCE: {
                    return "required";
                }
            }
            return "";
        }

        public static int apiNameHeaderLength() {
            return 4;
        }

        public int apiNameLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int getApiName(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getApiName(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapApiName(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String apiName() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public static int addressId() {
            return 7;
        }

        public static int addressSinceVersion() {
            return 0;
        }

        public static String addressCharacterEncoding() {
            return "UTF-8";
        }

        public static String addressMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
                case PRESENCE: {
                    return "required";
                }
            }
            return "";
        }

        public static int addressHeaderLength() {
            return 4;
        }

        public int addressLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int getAddress(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getAddress(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapAddress(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String address() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public String toString() {
            return this.appendTo(new StringBuilder(100)).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            builder.append('(');
            builder.append("apiName=");
            builder.append("'" + this.apiName() + "'");
            builder.append('|');
            builder.append("address=");
            builder.append("'" + this.address() + "'");
            builder.append(')');
            return builder;
        }
    }
}

