/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched.testing;

import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.ActorThread;
import io.zeebe.util.sched.ActorThreadGroup;
import io.zeebe.util.sched.ActorTimerQueue;
import io.zeebe.util.sched.TaskScheduler;
import io.zeebe.util.sched.clock.ActorClock;
import io.zeebe.util.sched.clock.ControlledActorClock;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import io.zeebe.util.sched.metrics.ActorThreadMetrics;
import io.zeebe.util.sched.testing.ControlledActorThread;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import org.junit.Assert;
import org.junit.rules.ExternalResource;

public class ControlledActorSchedulerRule
extends ExternalResource {
    private final ActorScheduler actorScheduler;
    private final ControlledActorThread controlledActorTaskRunner;
    private final ThreadPoolExecutor blockingTasksRunner;
    private final ControlledActorClock clock = new ControlledActorClock();

    public ControlledActorSchedulerRule() {
        ControlledActorThreadFactory actorTaskRunnerFactory = new ControlledActorThreadFactory();
        ActorTimerQueue timerQueue = new ActorTimerQueue(this.clock, 1);
        ActorScheduler.ActorSchedulerBuilder builder = ActorScheduler.newActorScheduler().setActorClock(this.clock).setCpuBoundActorThreadCount(1).setIoBoundActorThreadCount(0).setActorThreadFactory(actorTaskRunnerFactory).setBlockingTasksShutdownTime(Duration.ofSeconds(0L)).setActorTimerQueue(timerQueue);
        this.actorScheduler = builder.build();
        this.controlledActorTaskRunner = actorTaskRunnerFactory.controlledThread;
        this.blockingTasksRunner = builder.getBlockingTasksRunner();
    }

    protected void before() throws Throwable {
        this.actorScheduler.start();
    }

    protected void after() {
        this.actorScheduler.stop();
    }

    public ActorFuture<Void> submitActor(Actor actor) {
        return this.actorScheduler.submitActor(actor);
    }

    public ActorScheduler get() {
        return this.actorScheduler;
    }

    public void awaitBlockingTasksCompleted(int i) {
        long currentTimeMillis = System.currentTimeMillis();
        while (System.currentTimeMillis() - currentTimeMillis < 5000L) {
            long completedTaskCount = this.blockingTasksRunner.getCompletedTaskCount();
            if (completedTaskCount < (long)i) continue;
            return;
        }
        Assert.fail((String)("could not complete " + i + " blocking tasks within 5s"));
    }

    public void workUntilDone() {
        this.controlledActorTaskRunner.workUntilDone();
    }

    public void waitForTimer(Duration timeToWait) {
        this.clock.addTime(timeToWait);
        this.workUntilDone();
    }

    public <T> ActorFuture<T> call(final Callable<T> callable) {
        final CompletableActorFuture future = new CompletableActorFuture();
        this.submitActor(new Actor(){

            @Override
            protected void onActorStarted() {
                this.actor.run(() -> {
                    try {
                        future.complete(callable.call());
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                    }
                });
            }
        });
        return future;
    }

    public ControlledActorClock getClock() {
        return this.clock;
    }

    static class ControlledActorThreadFactory
    implements ActorScheduler.ActorThreadFactory {
        private ControlledActorThread controlledThread;

        ControlledActorThreadFactory() {
        }

        @Override
        public ActorThread newThread(String name, int id, ActorThreadGroup threadGroup, TaskScheduler taskScheduler, ActorClock clock, ActorThreadMetrics metrics, ActorTimerQueue timerQueue) {
            this.controlledThread = new ControlledActorThread(name, id, threadGroup, taskScheduler, clock, metrics, timerQueue);
            return this.controlledThread;
        }
    }
}

