/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched.testing;

import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.FutureUtil;
import io.zeebe.util.sched.clock.ActorClock;
import io.zeebe.util.sched.future.ActorFuture;
import org.junit.rules.ExternalResource;

public class ActorSchedulerRule
extends ExternalResource {
    private final ActorScheduler actorScheduler;
    private ActorScheduler.ActorSchedulerBuilder builder;

    public ActorSchedulerRule(int numOfThreads, ActorClock clock) {
        this(numOfThreads, 2, clock);
    }

    public ActorSchedulerRule(int numOfThreads, int numOfIoThreads, ActorClock clock) {
        this.builder = ActorScheduler.newActorScheduler().setCpuBoundActorThreadCount(numOfThreads).setIoBoundActorThreadCount(numOfIoThreads).setActorClock(clock);
        this.actorScheduler = this.builder.build();
    }

    public ActorSchedulerRule(int numOfThreads) {
        this(numOfThreads, null);
    }

    public ActorSchedulerRule(ActorClock clock) {
        this(Math.max(1, Runtime.getRuntime().availableProcessors() - 2), clock);
    }

    public ActorSchedulerRule() {
        this(null);
    }

    protected void before() {
        this.actorScheduler.start();
    }

    protected void after() {
        FutureUtil.join(this.actorScheduler.stop());
    }

    public ActorFuture<Void> submitActor(Actor actor) {
        return this.actorScheduler.submitActor(actor);
    }

    public ActorFuture<Void> submitActor(Actor actor, boolean useCountersManager) {
        return this.actorScheduler.submitActor(actor, useCountersManager);
    }

    public ActorScheduler get() {
        return this.actorScheduler;
    }

    public ActorScheduler.ActorSchedulerBuilder getBuilder() {
        return this.builder;
    }
}

