/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched.metrics;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.status.ConcurrentCountersManager;
import org.agrona.concurrent.status.CountersReader;

public class SchedulerMetrics {
    public static final String TASK_MAX_EXECUTION_TIME_MICROS_PROP = "io.zeebe.scheduler.taskMaxExecutionTimeMicros";
    public static final int TASK_MAX_EXECUTION_TIME_NANOS = 1000 * Integer.getInteger("io.zeebe.scheduler.taskMaxExecutionTimeMicros", -1);
    public static final boolean SHOULD_ENABLE_JUMBO_TASK_DETECTION = TASK_MAX_EXECUTION_TIME_NANOS >= 0;
    public static final int TYPE_TEMPORAL_VALUE = 1;

    public static void printMetrics(final ConcurrentCountersManager countersManager, final PrintStream ps) {
        countersManager.forEach(new CountersReader.MetaData(){

            public void accept(int counterId, int typeId, DirectBuffer keyBuffer, String label) {
                long value = countersManager.getCounterValue(counterId);
                switch (typeId) {
                    case 1: {
                        long hours = TimeUnit.NANOSECONDS.toDays(value);
                        long minutes = TimeUnit.NANOSECONDS.toMinutes(value -= TimeUnit.HOURS.toNanos(hours));
                        long seconds = TimeUnit.NANOSECONDS.toSeconds(value -= TimeUnit.MINUTES.toNanos(minutes));
                        long millis = TimeUnit.NANOSECONDS.toMillis(value -= TimeUnit.SECONDS.toNanos(seconds));
                        long micros = TimeUnit.NANOSECONDS.toMicros(value -= TimeUnit.MILLISECONDS.toNanos(millis));
                        ps.format("%s:\t %dh %dm %02ds %03dms %03d\u03bcs\n", label, hours, minutes, seconds, millis, micros);
                        break;
                    }
                    default: {
                        ps.format("%s: %d\n", label, value);
                    }
                }
            }
        });
    }
}

