/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched.metrics;

import io.zeebe.util.metrics.Metric;
import io.zeebe.util.metrics.MetricsManager;

public class ActorThreadMetrics
implements AutoCloseable {
    private final Metric threadIdleTime;
    private final Metric threadBusyTime;
    private final Metric jobExecutionCount;
    private final Metric taskStealCount;
    private final Metric taskExecutionCount;

    public ActorThreadMetrics(String threadName, MetricsManager metricsManager) {
        this.threadIdleTime = metricsManager.newMetric("scheduler_thread_runtime_ns").type("counter").label("thread", threadName).label("mode", "idle").create();
        this.threadBusyTime = metricsManager.newMetric("scheduler_thread_runtime_ns").type("counter").label("thread", threadName).label("mode", "busy").create();
        this.jobExecutionCount = metricsManager.newMetric("scheduler_thread_job_count").type("counter").label("thread", threadName).create();
        this.taskStealCount = metricsManager.newMetric("scheduler_thread_task_count").type("counter").label("thread", threadName).label("type", "steal").create();
        this.taskExecutionCount = metricsManager.newMetric("scheduler_thread_task_count").type("counter").label("thread", threadName).label("type", "run").create();
    }

    public void incrementTaskStealCount() {
        this.taskStealCount.incrementOrdered();
    }

    public void incrementTaskExecutionCount() {
        this.taskExecutionCount.incrementOrdered();
    }

    public void incrementJobCount() {
        this.jobExecutionCount.incrementOrdered();
    }

    public void recordRunnerIdleTime(long time) {
        this.threadIdleTime.getAndAddOrdered(time);
    }

    public void recordRunnerBusyTime(long time) {
        this.threadBusyTime.getAndAddOrdered(time);
    }

    @Override
    public void close() {
        this.jobExecutionCount.close();
        this.taskStealCount.close();
        this.threadIdleTime.close();
        this.threadBusyTime.close();
        this.taskExecutionCount.close();
    }
}

