/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched.future;

import io.zeebe.util.sched.ActorTask;
import io.zeebe.util.sched.ActorThread;
import io.zeebe.util.sched.FutureUtil;
import io.zeebe.util.sched.future.ActorFuture;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.ManyToOneConcurrentLinkedQueue;

public class CompletableActorFuture<V>
implements ActorFuture<V> {
    private static final long STATE_OFFSET;
    private static final int AWAITING_RESULT = 1;
    private static final int COMPLETING = 2;
    private static final int COMPLETED = 3;
    private static final int COMPLETED_EXCEPTIONALLY = 4;
    private static final int CLOSED = 5;
    private final ManyToOneConcurrentLinkedQueue<ActorTask> blockedTasks = new ManyToOneConcurrentLinkedQueue();
    private volatile int state = 5;
    private final ReentrantLock completionLock = new ReentrantLock();
    private Condition isDoneCondition;
    protected V value;
    protected String failure;
    protected Throwable failureCause;

    public CompletableActorFuture() {
        this.setAwaitingResult();
    }

    private CompletableActorFuture(V value) {
        this.value = value;
        this.state = 3;
    }

    private CompletableActorFuture(Throwable throwable) {
        this.ensureValidThrowable(throwable);
        this.failure = throwable.getMessage();
        this.failureCause = throwable;
        this.state = 4;
    }

    private void ensureValidThrowable(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("Throwable must not be null.");
        }
    }

    public void setAwaitingResult() {
        this.state = 1;
        this.isDoneCondition = this.completionLock.newCondition();
    }

    public static <V> CompletableActorFuture<V> completed(V result) {
        return new CompletableActorFuture<V>(result);
    }

    public static <V> CompletableActorFuture<V> completedExceptionally(Throwable throwable) {
        return new CompletableActorFuture<V>(throwable);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        int state = this.state;
        return state == 3 || state == 4;
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.state == 4;
    }

    public boolean isAwaitingResult() {
        return this.state == 1;
    }

    @Override
    public void block(ActorTask onCompletion) {
        this.blockedTasks.add((Object)onCompletion);
    }

    @Override
    public V get() throws ExecutionException, InterruptedException {
        try {
            return this.get(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException, InterruptedException {
        if (ActorThread.current() != null) {
            if (!this.isDone()) {
                throw new IllegalStateException("Actor call get() on future which has not completed. Actors must be non-blocking. Use actor.runOnCompletion().");
            }
        } else {
            this.completionLock.lock();
            try {
                long deadline = System.nanoTime() + unit.toNanos(timeout);
                while (!this.isDone()) {
                    long remaining = deadline - System.nanoTime();
                    if (remaining < 0L) {
                        throw new TimeoutException("Timeout after: " + timeout + " " + (Object)((Object)unit));
                    }
                    this.isDoneCondition.await(remaining, TimeUnit.NANOSECONDS);
                }
            }
            finally {
                this.completionLock.unlock();
            }
        }
        if (this.isCompletedExceptionally()) {
            throw new ExecutionException(this.failure, this.failureCause);
        }
        return this.value;
    }

    @Override
    public void complete(V value) {
        if (!UnsafeAccess.UNSAFE.compareAndSwapInt(this, STATE_OFFSET, 1, 2)) {
            String err = "Cannot complete future, the future is already completed " + (this.state == 4 ? "exceptionally with " + this.failure + " " : " with value " + value);
            throw new IllegalStateException(err);
        }
        this.value = value;
        this.state = 3;
        this.notifyBlockedTasks();
    }

    @Override
    public void completeExceptionally(String failure, Throwable throwable) {
        this.ensureValidThrowable(throwable);
        if (!UnsafeAccess.UNSAFE.compareAndSwapInt(this, STATE_OFFSET, 1, 2)) {
            String err = "Cannot complete future, the future is already completed " + (this.state == 4 ? "exceptionally with '" + failure + "' " : " with value " + this.value);
            throw new IllegalStateException(err);
        }
        this.failure = failure;
        this.failureCause = throwable;
        this.state = 4;
        this.notifyBlockedTasks();
    }

    @Override
    public void completeExceptionally(Throwable throwable) {
        this.ensureValidThrowable(throwable);
        this.completeExceptionally(throwable.getMessage(), throwable);
    }

    private void notifyBlockedTasks() {
        this.notifyAllInQueue((Queue<ActorTask>)this.blockedTasks);
        try {
            this.completionLock.lock();
            this.isDoneCondition.signalAll();
        }
        finally {
            this.completionLock.unlock();
        }
    }

    private void notifyAllInQueue(Queue<ActorTask> tasks) {
        while (!tasks.isEmpty()) {
            ActorTask task = tasks.poll();
            if (task == null) continue;
            task.tryWakeup();
        }
    }

    @Override
    public V join() {
        return (V)FutureUtil.join(this);
    }

    public boolean close() {
        int prevState = UnsafeAccess.UNSAFE.getAndSetInt(this, STATE_OFFSET, 5);
        if (prevState != 5) {
            this.value = null;
            this.failure = null;
            this.failureCause = null;
            this.notifyBlockedTasks();
        }
        return prevState != 5;
    }

    public boolean isClosed() {
        return this.state == 5;
    }

    @Override
    public Throwable getException() {
        if (!this.isCompletedExceptionally()) {
            throw new IllegalStateException("Cannot call getException(); future is not completed exceptionally.");
        }
        return this.failureCause;
    }

    public void completeWith(CompletableActorFuture<V> otherFuture) {
        if (!otherFuture.isDone()) {
            throw new IllegalArgumentException("Future is not completed, can't complete this future with uncompleted future.");
        }
        if (otherFuture.isCompletedExceptionally()) {
            this.completeExceptionally(otherFuture.failureCause);
        } else {
            this.complete(otherFuture.value);
        }
    }

    public String toString() {
        return "CompletableActorFuture{" + (this.isDone() ? (this.state == 3 ? "value= " + this.value : "failure= " + this.failureCause) : " not completed (state " + this.state + ")") + "}";
    }

    static {
        try {
            STATE_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(CompletableActorFuture.class.getDeclaredField("state"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

