/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched.channel;

import io.zeebe.util.sched.ActorCondition;
import io.zeebe.util.sched.channel.ActorConditions;
import io.zeebe.util.sched.channel.ConsumableChannel;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.ringbuffer.OneToOneRingBuffer;

public class OneToOneRingBufferChannel
extends OneToOneRingBuffer
implements ConsumableChannel {
    private final ActorConditions conditions = new ActorConditions();

    public OneToOneRingBufferChannel(AtomicBuffer buffer) {
        super(buffer);
    }

    @Override
    public boolean hasAvailable() {
        return this.consumerPosition() < this.producerPosition();
    }

    @Override
    public void registerConsumer(ActorCondition onDataAvailable) {
        this.conditions.registerConsumer(onDataAvailable);
    }

    @Override
    public void removeConsumer(ActorCondition onDataAvailable) {
        this.conditions.removeConsumer(onDataAvailable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(int msgTypeId, DirectBuffer srcBuffer, int srcIndex, int length) {
        try {
            boolean bl = super.write(msgTypeId, srcBuffer, srcIndex, length);
            return bl;
        }
        finally {
            this.conditions.signalConsumers();
        }
    }
}

