/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched;

import io.zeebe.util.sched.ActorExecutor;
import io.zeebe.util.sched.ActorJob;
import io.zeebe.util.sched.ActorSubscription;

public class BlockingPollSubscription
implements ActorSubscription,
Runnable {
    private final ActorJob subscriptionJob;
    private final Runnable blockingAction;
    private final ActorExecutor actorTaskExecutor;
    private volatile boolean isDone;
    private boolean isRecurring;

    public BlockingPollSubscription(ActorJob subscriptionJob, Runnable blockingAction, ActorExecutor actorTaskExecutor, boolean isRecurring) {
        this.subscriptionJob = subscriptionJob;
        this.blockingAction = blockingAction;
        this.actorTaskExecutor = actorTaskExecutor;
        this.isRecurring = isRecurring;
    }

    @Override
    public boolean poll() {
        return this.isDone;
    }

    @Override
    public ActorJob getJob() {
        return this.subscriptionJob;
    }

    @Override
    public boolean isRecurring() {
        return this.isRecurring;
    }

    @Override
    public void run() {
        try {
            this.blockingAction.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.onBlockingActionCompleted();
        }
    }

    private void onBlockingActionCompleted() {
        this.isDone = true;
        this.subscriptionJob.getTask().tryWakeup();
    }

    @Override
    public void onJobCompleted() {
        if (this.isRecurring) {
            this.submit();
        }
    }

    public void submit() {
        this.isDone = false;
        this.actorTaskExecutor.submitBlocking(this);
    }
}

