/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched;

import io.zeebe.util.metrics.MetricsManager;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorExecutor;
import io.zeebe.util.sched.ActorTask;
import io.zeebe.util.sched.ActorThread;
import io.zeebe.util.sched.ActorThreadGroup;
import io.zeebe.util.sched.ActorTimerQueue;
import io.zeebe.util.sched.CpuThreadGroup;
import io.zeebe.util.sched.IoThreadGroup;
import io.zeebe.util.sched.SchedulingHints;
import io.zeebe.util.sched.TaskScheduler;
import io.zeebe.util.sched.clock.ActorClock;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.metrics.ActorThreadMetrics;
import java.io.IOException;
import java.io.PrintStream;
import java.time.Duration;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;

public class ActorScheduler {
    private final AtomicReference<SchedulerState> state = new AtomicReference();
    private final ActorExecutor actorTaskExecutor;
    private final MetricsManager metricsManager;
    private final String schedulerName;

    public ActorScheduler(ActorSchedulerBuilder builder) {
        this.state.set(SchedulerState.NEW);
        this.actorTaskExecutor = builder.getActorExecutor();
        this.metricsManager = builder.getMetricsManager();
        this.schedulerName = builder.getSchedulerName();
    }

    public ActorFuture<Void> submitActor(Actor actor) {
        return this.submitActor(actor, false);
    }

    public ActorFuture<Void> submitActor(Actor actor, boolean collectTaskMetrics) {
        return this.actorTaskExecutor.submitCpuBound(actor.actor.task, collectTaskMetrics);
    }

    public ActorFuture<Void> submitActor(Actor actor, boolean collectTaskMetrics, int schedulingHints) {
        ActorFuture<Void> startingFuture;
        ActorTask task = actor.actor.task;
        if (SchedulingHints.isCpuBound(schedulingHints)) {
            task.setPriority(SchedulingHints.getPriority(schedulingHints));
            startingFuture = this.actorTaskExecutor.submitCpuBound(task, collectTaskMetrics);
        } else {
            startingFuture = this.actorTaskExecutor.submitIoBoundTask(task, collectTaskMetrics);
        }
        return startingFuture;
    }

    public void start() {
        if (!this.state.compareAndSet(SchedulerState.NEW, SchedulerState.RUNNING)) {
            throw new IllegalStateException("Cannot start scheduler already started.");
        }
        this.actorTaskExecutor.start();
    }

    public Future<Void> stop() {
        if (this.state.compareAndSet(SchedulerState.RUNNING, SchedulerState.TERMINATING)) {
            return this.actorTaskExecutor.closeAsync().thenRun(() -> this.state.set(SchedulerState.TERMINATED));
        }
        throw new IllegalStateException("Cannot stop scheduler not running");
    }

    public void dumpMetrics(PrintStream ps) {
        ExpandableArrayBuffer buff = new ExpandableArrayBuffer();
        this.metricsManager.dump((MutableDirectBuffer)buff, 0, System.currentTimeMillis());
        try {
            ps.write(buff.byteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setBlockingTasksShutdownTime(Duration shutdownTime) {
        this.actorTaskExecutor.setBlockingTasksShutdownTime(shutdownTime);
    }

    public static ActorSchedulerBuilder newActorScheduler() {
        return new ActorSchedulerBuilder();
    }

    public static ActorScheduler newDefaultActorScheduler() {
        return new ActorSchedulerBuilder().build();
    }

    public MetricsManager getMetricsManager() {
        return this.metricsManager;
    }

    private static enum SchedulerState {
        NEW,
        RUNNING,
        TERMINATING,
        TERMINATED;

    }

    public static class BlockingTasksThreadFactory
    implements ThreadFactory {
        final AtomicLong idGenerator = new AtomicLong();
        private final String schedulerName;

        public BlockingTasksThreadFactory(String schedulerName) {
            this.schedulerName = schedulerName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("zb-blocking-task-runner-" + this.idGenerator.incrementAndGet() + "-" + this.schedulerName);
            return thread;
        }
    }

    public static class DefaultActorThreadFactory
    implements ActorThreadFactory {
        @Override
        public ActorThread newThread(String name, int id, ActorThreadGroup threadGroup, TaskScheduler taskScheduler, ActorClock clock, ActorThreadMetrics metrics, ActorTimerQueue timerQueue) {
            return new ActorThread(name, id, threadGroup, taskScheduler, clock, metrics, timerQueue);
        }
    }

    public static interface ActorThreadFactory {
        public ActorThread newThread(String var1, int var2, ActorThreadGroup var3, TaskScheduler var4, ActorClock var5, ActorThreadMetrics var6, ActorTimerQueue var7);
    }

    public static class ActorSchedulerBuilder {
        private String schedulerName = "";
        private ActorClock actorClock;
        private MetricsManager metricsManager;
        private int cpuBoundThreadsCount = Math.max(1, Runtime.getRuntime().availableProcessors() - 2);
        private ActorThreadGroup cpuBoundActorGroup;
        private double[] priorityQuotas = new double[]{0.6, 0.3, 0.1};
        private int ioBoundThreadsCount = 2;
        private ActorThreadGroup ioBoundActorGroup;
        private int[] ioDeviceConcurrency = new int[]{2};
        private ActorThreadFactory actorThreadFactory;
        private ThreadPoolExecutor blockingTasksRunner;
        private Duration blockingTasksShutdownTime = Duration.ofSeconds(15L);
        private ActorExecutor actorExecutor;
        private ActorTimerQueue actorTimerQueue;

        public ActorSchedulerBuilder setActorTimerQueue(ActorTimerQueue actorTimerQueue) {
            this.actorTimerQueue = actorTimerQueue;
            return this;
        }

        public ActorSchedulerBuilder setActorClock(ActorClock actorClock) {
            this.actorClock = actorClock;
            return this;
        }

        public ActorSchedulerBuilder setMetricsManager(MetricsManager metricsManager) {
            this.metricsManager = metricsManager;
            return this;
        }

        public ActorSchedulerBuilder setCpuBoundActorThreadCount(int actorThreadCount) {
            this.cpuBoundThreadsCount = actorThreadCount;
            return this;
        }

        public ActorSchedulerBuilder setIoBoundActorThreadCount(int ioBoundActorsThreadCount) {
            this.ioBoundThreadsCount = ioBoundActorsThreadCount;
            return this;
        }

        public ActorSchedulerBuilder setPriorityQuotas(double[] priorityQuotas) {
            this.priorityQuotas = priorityQuotas;
            return this;
        }

        public ActorSchedulerBuilder setActorThreadFactory(ActorThreadFactory actorThreadFactory) {
            this.actorThreadFactory = actorThreadFactory;
            return this;
        }

        public ActorSchedulerBuilder setBlockingTasksRunner(ThreadPoolExecutor blockingTasksRunner) {
            this.blockingTasksRunner = blockingTasksRunner;
            return this;
        }

        public ActorSchedulerBuilder setBlockingTasksShutdownTime(Duration blockingTasksShutdownTime) {
            this.blockingTasksShutdownTime = blockingTasksShutdownTime;
            return this;
        }

        public ActorSchedulerBuilder setActorExecutor(ActorExecutor actorExecutor) {
            this.actorExecutor = actorExecutor;
            return this;
        }

        public ActorSchedulerBuilder setIoDeviceConcurrency(int[] ioDeviceConcurrency) {
            this.ioDeviceConcurrency = ioDeviceConcurrency;
            return this;
        }

        public ActorSchedulerBuilder setSchedulerName(String schedulerName) {
            this.schedulerName = schedulerName;
            return this;
        }

        public String getSchedulerName() {
            return this.schedulerName;
        }

        public ActorClock getActorClock() {
            return this.actorClock;
        }

        public ActorTimerQueue getActorTimerQueue() {
            return this.actorTimerQueue;
        }

        public MetricsManager getMetricsManager() {
            return this.metricsManager;
        }

        public int getCpuBoundActorThreadCount() {
            return this.cpuBoundThreadsCount;
        }

        public int getIoBoundActorThreadCount() {
            return this.ioBoundThreadsCount;
        }

        public double[] getPriorityQuotas() {
            return this.priorityQuotas;
        }

        public ActorThreadFactory getActorThreadFactory() {
            return this.actorThreadFactory;
        }

        public ThreadPoolExecutor getBlockingTasksRunner() {
            return this.blockingTasksRunner;
        }

        public Duration getBlockingTasksShutdownTime() {
            return this.blockingTasksShutdownTime;
        }

        public ActorExecutor getActorExecutor() {
            return this.actorExecutor;
        }

        public int[] getIoDeviceConcurrency() {
            return this.ioDeviceConcurrency;
        }

        public ActorThreadGroup getCpuBoundActorThreads() {
            return this.cpuBoundActorGroup;
        }

        public ActorThreadGroup getIoBoundActorThreads() {
            return this.ioBoundActorGroup;
        }

        private void initMetricsManager() {
            if (this.metricsManager == null) {
                this.metricsManager = new MetricsManager();
            }
        }

        private void initActorThreadFactory() {
            if (this.actorThreadFactory == null) {
                this.actorThreadFactory = new DefaultActorThreadFactory();
            }
        }

        private void initBlockingTaskRunner() {
            if (this.blockingTasksRunner == null) {
                this.blockingTasksRunner = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new BlockingTasksThreadFactory(this.schedulerName));
            }
        }

        private void initIoBoundActorThreadGroup() {
            if (this.ioBoundActorGroup == null) {
                this.ioBoundActorGroup = new IoThreadGroup(this);
            }
        }

        private void initCpuBoundActorThreadGroup() {
            if (this.cpuBoundActorGroup == null) {
                this.cpuBoundActorGroup = new CpuThreadGroup(this);
            }
        }

        private void initActorExecutor() {
            if (this.actorExecutor == null) {
                this.actorExecutor = new ActorExecutor(this);
            }
        }

        public ActorScheduler build() {
            this.initMetricsManager();
            this.initActorThreadFactory();
            this.initBlockingTaskRunner();
            this.initCpuBoundActorThreadGroup();
            this.initIoBoundActorThreadGroup();
            this.initActorExecutor();
            return new ActorScheduler(this);
        }
    }
}

