/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.metrics;

import io.zeebe.util.metrics.Metric;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.agrona.MutableDirectBuffer;

public class MetricsManager {
    private final List<Metric> metrics = new ArrayList<Metric>();
    private final String prefix;
    private final Map<String, String> globalLabels;
    private final Consumer<Metric> onClose = this::free;
    private final ReentrantLock lock = new ReentrantLock();

    public MetricsManager() {
        this("zb_", new HashMap<String, String>());
    }

    public MetricsManager(String prefix, Map<String, String> globalLabels) {
        this.prefix = prefix;
        this.globalLabels = globalLabels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metric allocate(String name, String type, String description, Map<String, String> labels) {
        this.lock.lock();
        try {
            labels.putAll(this.globalLabels);
            Metric metric = new Metric(this.prefix + name, type, description, labels, this.onClose);
            this.metrics.add(metric);
            Metric metric2 = metric;
            return metric2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public MetricBuilder newMetric(String name) {
        return new MetricBuilder(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dump(MutableDirectBuffer buffer, int offset, long now) {
        this.lock.lock();
        try {
            for (int i = 0; i < this.metrics.size(); ++i) {
                offset = this.metrics.get(i).dump(buffer, offset, now);
            }
            int n = offset;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void free(Metric metric) {
        this.lock.lock();
        try {
            this.metrics.remove(metric);
        }
        finally {
            this.lock.unlock();
        }
    }

    public class MetricBuilder {
        private final String name;
        private String type;
        private String description;
        private final Map<String, String> labels = new HashMap<String, String>();

        public MetricBuilder(String name) {
            this.name = name;
            this.type = "counter";
            this.description = "No description provided";
        }

        public MetricBuilder type(String type) {
            this.type = type;
            return this;
        }

        public MetricBuilder label(String name, String value) {
            this.labels.put(name, value);
            return this;
        }

        public MetricBuilder description(String description) {
            this.description = description;
            return this;
        }

        public Metric create() {
            return MetricsManager.this.allocate(this.name, this.type, this.description, this.labels);
        }
    }
}

