/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.collection;

import java.util.Arrays;
import java.util.function.LongConsumer;
import org.agrona.BitUtil;

public class LongRingBuffer {
    protected final long[] elements;
    protected final int capacity;
    protected final int bufferCapacity;
    protected volatile long head;
    protected volatile long tail;

    public LongRingBuffer(int capacity) {
        this.bufferCapacity = BitUtil.isPowerOfTwo((int)capacity) ? capacity : BitUtil.findNextPositivePowerOfTwo((int)capacity);
        this.elements = new long[this.bufferCapacity];
        Arrays.fill(this.elements, -1L);
        this.head = -1L;
        this.tail = -1L;
        this.capacity = capacity;
    }

    public boolean isSaturated() {
        return this.size() == this.capacity;
    }

    public void consumeAscendingUntilInclusive(long element) {
        while (this.head != this.tail && this.elements[LongRingBuffer.mapToBufferIndex(this.tail + 1L, this.bufferCapacity)] <= element) {
            ++this.tail;
        }
    }

    public int consume(LongConsumer consumer) {
        return this.consume(consumer, Integer.MAX_VALUE);
    }

    public int consume(LongConsumer consumer, int maxElements) {
        int elementCounter;
        for (elementCounter = 0; this.head != this.tail && elementCounter < maxElements; ++elementCounter) {
            long nextElement = this.elements[LongRingBuffer.mapToBufferIndex(this.tail + 1L, this.bufferCapacity)];
            consumer.accept(nextElement);
            ++this.tail;
        }
        return elementCounter;
    }

    protected static int mapToBufferIndex(long indexCounter, int bufferCapacity) {
        return (int)(indexCounter & (long)(bufferCapacity - 1));
    }

    public int size() {
        return (int)(this.head - this.tail);
    }

    public boolean addElementToHead(long element) {
        if (this.size() == this.capacity) {
            return false;
        }
        this.elements[LongRingBuffer.mapToBufferIndex((long)(this.head + 1L), (int)this.bufferCapacity)] = element;
        ++this.head;
        return true;
    }
}

