/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.collection;

public class CompactListDescriptor {
    public static final int HEADER_OFFSET;
    public static final int SIZE_OFFSET;
    public static final int ELEMENT_MAX_LENGTH_OFFSET;
    public static final int CAPACITY_OFFSET;
    public static final int HEADER_LENGTH;
    public static final int DATA_SECTION_OFFSET;
    public static final int ELEMENT_HEADER_LENGTH;
    public static final int ELEMENT_LENGTH_OFFSET;

    public static int headerOffset() {
        return HEADER_OFFSET;
    }

    public static int sizeOffset() {
        return SIZE_OFFSET;
    }

    public static int elementMaxLengthOffset() {
        return ELEMENT_MAX_LENGTH_OFFSET;
    }

    public static int capacityOffset() {
        return CAPACITY_OFFSET;
    }

    public static int dataSectionOffset() {
        return DATA_SECTION_OFFSET;
    }

    public static int headerLength() {
        return HEADER_LENGTH;
    }

    public static int requiredBufferCapacity(int framedLength, int capacity) {
        return HEADER_LENGTH + framedLength * capacity;
    }

    public static int elementOffset(int framedLength, int idx) {
        return HEADER_LENGTH + framedLength * idx;
    }

    public static int elementLengthOffset(int offset) {
        return ELEMENT_LENGTH_OFFSET + offset;
    }

    public static int elementDataOffset(int offset) {
        return ELEMENT_HEADER_LENGTH + offset;
    }

    public static int framedLength(int length) {
        return ELEMENT_HEADER_LENGTH + length;
    }

    static {
        int offset;
        HEADER_OFFSET = offset = 0;
        SIZE_OFFSET = offset;
        ELEMENT_MAX_LENGTH_OFFSET = offset += 4;
        CAPACITY_OFFSET = offset += 4;
        HEADER_LENGTH = offset += 4;
        DATA_SECTION_OFFSET = offset;
        ELEMENT_LENGTH_OFFSET = offset = 0;
        ELEMENT_HEADER_LENGTH = offset += 4;
    }
}

