/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.collection;

import io.zeebe.util.CloseableSilently;
import io.zeebe.util.allocation.AllocatedBuffer;
import io.zeebe.util.allocation.BufferAllocator;
import io.zeebe.util.collection.CompactListDescriptor;
import io.zeebe.util.collection.CompactListIterator;
import java.io.InputStream;
import java.util.Comparator;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.io.DirectBufferInputStream;

public class CompactList
implements Iterable<MutableDirectBuffer>,
CloseableSilently {
    protected final AllocatedBuffer allocatedBuffer;
    protected final UnsafeBuffer listBuffer;
    protected final UnsafeBuffer elementBuffer = new UnsafeBuffer(0L, 0);
    protected final int framedElementLength;
    protected final CompactListIterator iterator;

    public CompactList(int elementMaxLength, int capacity, BufferAllocator bufferAllocator) {
        this(bufferAllocator.allocate(CompactListDescriptor.requiredBufferCapacity(CompactListDescriptor.framedLength(elementMaxLength), capacity)), elementMaxLength, capacity);
    }

    public CompactList(AllocatedBuffer allocatedBuffer, int elementMaxLength, int capacity) {
        this.allocatedBuffer = allocatedBuffer;
        this.framedElementLength = CompactListDescriptor.framedLength(elementMaxLength);
        int requiredBufferCapacity = CompactListDescriptor.requiredBufferCapacity(this.framedElementLength, capacity);
        int bufferCapacity = allocatedBuffer.capacity();
        if (bufferCapacity < requiredBufferCapacity) {
            String errorMessage = String.format("Not enough capacity in provided buffer. Has %d, required %d", bufferCapacity, requiredBufferCapacity);
            throw new IllegalArgumentException(errorMessage);
        }
        this.listBuffer = new UnsafeBuffer(0L, 0);
        this.listBuffer.wrap(allocatedBuffer.getRawBuffer(), 0, requiredBufferCapacity);
        this.listBuffer.putInt(CompactListDescriptor.sizeOffset(), 0);
        this.listBuffer.putInt(CompactListDescriptor.elementMaxLengthOffset(), elementMaxLength);
        this.listBuffer.putInt(CompactListDescriptor.capacityOffset(), capacity);
        this.iterator = new CompactListIterator(this);
    }

    public CompactList(UnsafeBuffer listBuffer) {
        this.listBuffer = listBuffer;
        int elementMaxLength = listBuffer.getInt(CompactListDescriptor.elementMaxLengthOffset());
        this.framedElementLength = CompactListDescriptor.framedLength(elementMaxLength);
        this.iterator = new CompactListIterator(this);
        this.allocatedBuffer = null;
    }

    public void add(DirectBuffer srcBuffer) {
        this.add(srcBuffer, 0, srcBuffer.capacity());
    }

    public void add(DirectBuffer srcBuffer, int offset, int length) {
        this.add(srcBuffer, offset, length, Math.max(this.size(), 0));
    }

    public void add(DirectBuffer srcBuffer, int offset, int length, int idx) {
        int size = this.size();
        int capacity = this.capacity();
        this.elementLengthCheck(length);
        this.boundsCheck(idx, size);
        if (capacity == size) {
            String errorMessage = String.format("Cannot add element: list is full. Capacity=%d", capacity);
            throw new IllegalArgumentException(errorMessage);
        }
        int elementOffset = CompactListDescriptor.elementOffset(this.framedElementLength, idx);
        if (size - idx > 0) {
            int copyOffset = elementOffset + this.framedElementLength;
            int copyLength = (size - idx) * this.framedElementLength;
            this.listBuffer.putBytes(copyOffset, (DirectBuffer)this.listBuffer, elementOffset, copyLength);
        }
        this.setValue(srcBuffer, offset, length, idx, elementOffset);
        this.setSize(size + 1);
    }

    public void set(int idx, DirectBuffer srcBuffer) {
        this.set(idx, srcBuffer, 0, srcBuffer.capacity());
    }

    public void set(int idx, DirectBuffer srcBuffer, int offset, int length) {
        int size = this.size();
        this.elementLengthCheck(length);
        this.boundsCheckIncludingSize(idx, size);
        this.setValue(srcBuffer, offset, length, idx);
    }

    public void remove(int idx) {
        int size = this.size();
        this.boundsCheckIncludingSize(idx, size);
        if (size - idx > 1) {
            int elementOffset = CompactListDescriptor.elementOffset(this.framedElementLength, idx);
            int copyOffset = elementOffset + this.framedElementLength;
            int copyLength = (size - idx - 1) * this.framedElementLength;
            this.listBuffer.putBytes(elementOffset, (DirectBuffer)this.listBuffer, copyOffset, copyLength);
        }
        int lastElementOffset = CompactListDescriptor.elementOffset(this.framedElementLength, size - 1);
        this.setMemory(lastElementOffset, this.framedElementLength, (byte)0);
        this.setSize(size - 1);
    }

    public int size() {
        return this.listBuffer.getInt(CompactListDescriptor.sizeOffset());
    }

    public int sizeVolatile() {
        return this.listBuffer.getIntVolatile(CompactListDescriptor.sizeOffset());
    }

    public int capacity() {
        return this.listBuffer.getInt(CompactListDescriptor.capacityOffset());
    }

    public int maxElementDataLength() {
        return this.listBuffer.getInt(CompactListDescriptor.elementMaxLengthOffset());
    }

    public int get(int idx, MutableDirectBuffer dstBuffer, int offset) {
        int size = this.size();
        this.boundsCheckIncludingSize(idx, size);
        int elementOffset = CompactListDescriptor.elementOffset(this.framedElementLength, idx);
        int length = this.listBuffer.getInt(CompactListDescriptor.elementLengthOffset(elementOffset));
        dstBuffer.putBytes(offset, (DirectBuffer)this.listBuffer, CompactListDescriptor.elementDataOffset(elementOffset), length);
        return length;
    }

    public int wrap(int idx, MutableDirectBuffer dstBuffer) {
        int size = this.size();
        this.boundsCheckIncludingSize(idx, size);
        int elementOffset = CompactListDescriptor.elementOffset(this.framedElementLength, idx);
        int length = this.listBuffer.getInt(CompactListDescriptor.elementLengthOffset(elementOffset));
        dstBuffer.wrap((DirectBuffer)this.listBuffer, CompactListDescriptor.elementDataOffset(elementOffset), length);
        return length;
    }

    public int getEncodedSize() {
        return this.listBuffer.capacity();
    }

    public DirectBuffer getRawBuffer() {
        return this.listBuffer;
    }

    public int find(DirectBuffer key, Comparator<DirectBuffer> c) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            this.wrap(mid, (MutableDirectBuffer)this.elementBuffer);
            int cmp = c.compare((DirectBuffer)this.elementBuffer, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int copyInto(MutableDirectBuffer dstBuffer, int offset) {
        int length = this.listBuffer.capacity();
        dstBuffer.putBytes(offset, (DirectBuffer)this.listBuffer, 0, length);
        return length;
    }

    public void clear() {
        int size = this.size();
        int start = CompactListDescriptor.elementOffset(this.framedElementLength, 0);
        int end = this.framedElementLength * size;
        this.setMemory(start, end, (byte)0);
        this.setSize(0);
    }

    protected void boundsCheck(int index, int size) {
        if (index < 0 || index > size) {
            throw this.indexOutOfBoundsException(index, size);
        }
    }

    protected void boundsCheckIncludingSize(int index, int size) {
        if (index < 0 || index >= size) {
            throw this.indexOutOfBoundsException(index, size);
        }
    }

    protected IndexOutOfBoundsException indexOutOfBoundsException(int index, int size) {
        String message = String.format("map=%d, size=%d", index, size);
        return new IndexOutOfBoundsException(message);
    }

    protected void elementLengthCheck(int length) {
        int maxElementDataLength = this.maxElementDataLength();
        if (maxElementDataLength < length) {
            String message = String.format("Element length larger than maximum size: %d > %d", length, maxElementDataLength);
            throw new IllegalArgumentException(message);
        }
    }

    protected void setSize(int size) {
        this.listBuffer.putInt(CompactListDescriptor.sizeOffset(), size);
    }

    protected void setValue(DirectBuffer buffer, int offset, int length, int idx) {
        int elementOffset = CompactListDescriptor.elementOffset(this.framedElementLength, idx);
        this.setValue(buffer, offset, length, idx, elementOffset);
    }

    protected void setValue(DirectBuffer buffer, int offset, int length, int idx, int elementOffset) {
        this.setMemory(elementOffset, this.framedElementLength, (byte)0);
        this.listBuffer.putInt(CompactListDescriptor.elementLengthOffset(elementOffset), length);
        this.listBuffer.putBytes(CompactListDescriptor.elementDataOffset(elementOffset), buffer, offset, length);
    }

    protected void setMemory(int idx, int length, byte value) {
        this.listBuffer.setMemory(idx, length, value);
    }

    public CompactListIterator iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    public InputStream toInputStream() {
        return new DirectBufferInputStream((DirectBuffer)this.listBuffer);
    }

    @Override
    public void close() {
        if (this.allocatedBuffer != null) {
            this.allocatedBuffer.close();
        }
    }
}

