/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.allocation;

import io.zeebe.util.allocation.AllocatedBuffer;
import io.zeebe.util.allocation.AllocatedMappedFile;
import io.zeebe.util.allocation.BufferAllocator;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class MappedFileAllocator
implements BufferAllocator {
    private final File mappedFile;

    public MappedFileAllocator(File mappedFile) {
        this.mappedFile = mappedFile;
    }

    @Override
    public AllocatedBuffer allocate(int capacity) {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.mappedFile, "rw");
            MappedByteBuffer mappedBuffer = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, capacity);
            return new AllocatedMappedFile(mappedBuffer, raf);
        }
        catch (Exception e) {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new RuntimeException("Could not map file " + this.mappedFile + " into memory: " + e.getMessage(), e);
        }
    }
}

