/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util;

import com.moandjiezana.toml.Toml;
import io.zeebe.util.Loggers;
import java.io.File;
import java.io.InputStream;
import org.slf4j.Logger;

public class TomlConfigurationReader {
    public static final Logger LOG = Loggers.CONFIG_LOGGER;

    public static <T> T read(String filePath, Class<T> type) {
        File file = new File(filePath);
        LOG.info("Reading configuration for class {} from file {} ", type, (Object)file.getAbsolutePath());
        return (T)new Toml().read(file).to(type);
    }

    public static <T> T read(InputStream configStream, Class<T> type) {
        LOG.info("Reading configuration for class {} from input stream", type);
        return (T)new Toml().read(configStream).to(type);
    }
}

