/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util;

import io.zeebe.util.Loggers;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class Environment {
    private static final Logger LOG = Loggers.CONFIG_LOGGER;
    private final Map<String, String> environment;

    public Environment() {
        this(System.getenv());
    }

    public Environment(Map<String, String> environment) {
        this.environment = environment;
    }

    public Optional<String> get(String name) {
        return Optional.ofNullable(this.environment.get(name));
    }

    public Optional<Integer> getInt(String name) {
        try {
            return this.get(name).map(Integer::valueOf);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse environment variable {}", (Object)name, (Object)e);
            return Optional.empty();
        }
    }

    public Optional<Boolean> getBool(String name) {
        try {
            return this.get(name).map(Boolean::valueOf);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse environment variable {}", (Object)name, (Object)e);
            return Optional.empty();
        }
    }

    public Optional<List<String>> getList(String name) {
        return this.get(name).map(v -> v.split(",")).map(Arrays::asList).map(list -> list.stream().map(String::trim).filter(e -> !e.isEmpty()).collect(Collectors.toList()));
    }
}

