/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util;

import io.zeebe.util.EnsureUtil;
import java.util.Objects;
import java.util.function.BiConsumer;

@FunctionalInterface
public interface CheckedConsumer<T> {
    public void accept(T var1) throws Exception;

    default public CheckedConsumer<T> andThen(CheckedConsumer<T> nextConsumer) {
        Objects.requireNonNull(nextConsumer);
        return t -> {
            this.accept(t);
            nextConsumer.accept(t);
        };
    }

    default public CheckedConsumer<T> andOnException(BiConsumer<T, Exception> exceptionHandler) {
        Objects.requireNonNull(exceptionHandler);
        return t -> {
            try {
                this.accept(t);
            }
            catch (Exception e) {
                exceptionHandler.accept(t, e);
            }
        };
    }

    default public CheckedConsumer<T> andOnExceptionRetry(int retries, BiConsumer<T, Exception> retryExceptionHandler) {
        EnsureUtil.ensureGreaterThanOrEqual("times", retries, 0L);
        Objects.requireNonNull(retryExceptionHandler);
        return t -> {
            int invocation = -1;
            while (true) {
                ++invocation;
                try {
                    this.accept(t);
                    return;
                }
                catch (Exception e) {
                    if (invocation >= retries) {
                        throw e;
                    }
                    retryExceptionHandler.accept(t, e);
                    if (invocation < retries) continue;
                    return;
                }
                break;
            }
        };
    }
}

