/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.utils.config;

import io.atomix.core.AtomixRegistry;
import io.atomix.utils.ConfiguredType;
import io.atomix.utils.config.TypedConfig;

public class PolymorphicTypeMapper {
    private final String typePath;
    private final Class<? extends TypedConfig> configClass;
    private final Class<? extends ConfiguredType> typeClass;

    public PolymorphicTypeMapper(String typePath, Class<? extends TypedConfig> configClass, Class<? extends ConfiguredType> typeClass) {
        this.typePath = typePath;
        this.configClass = configClass;
        this.typeClass = typeClass;
    }

    public Class<? extends TypedConfig> getConfigClass() {
        return this.configClass;
    }

    public Class<? extends ConfiguredType> getTypeClass() {
        return this.typeClass;
    }

    public String getTypePath() {
        return this.typePath;
    }

    public Class<? extends TypedConfig<?>> getConcreteClass(AtomixRegistry registry, String typeName) {
        ConfiguredType type = registry.getType(this.typeClass, typeName);
        if (type == null) {
            return null;
        }
        return type.newConfig().getClass();
    }
}

