/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.profile;

import com.google.common.collect.Sets;
import io.atomix.core.AtomixConfig;
import io.atomix.core.profile.ConsensusProfileBuilder;
import io.atomix.core.profile.ConsensusProfileConfig;
import io.atomix.core.profile.Profile;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.raft.partition.RaftPartitionGroupConfig;
import io.atomix.raft.partition.RaftStorageConfig;
import java.util.Collection;

public class ConsensusProfile
implements Profile {
    public static final Type TYPE = new Type();
    private final ConsensusProfileConfig config;

    ConsensusProfile(String ... members) {
        this(Sets.newHashSet((Object[])members));
    }

    ConsensusProfile(Collection<String> members) {
        this(new ConsensusProfileConfig().setMembers(Sets.newHashSet(members)));
    }

    ConsensusProfile(ConsensusProfileConfig config) {
        this.config = config;
    }

    public static ConsensusProfileBuilder builder() {
        return new ConsensusProfileBuilder();
    }

    public ConsensusProfileConfig config() {
        return this.config;
    }

    @Override
    public void configure(AtomixConfig config) {
        config.setManagementGroup((PartitionGroupConfig<?>)((RaftPartitionGroupConfig)((RaftPartitionGroupConfig)new RaftPartitionGroupConfig().setName(this.config.getManagementGroup())).setPartitionSize(this.config.getMembers().size()).setPartitions(1)).setMembers(this.config.getMembers()).setStorageConfig(new RaftStorageConfig().setDirectory(String.format("%s/%s", this.config.getDataPath(), this.config.getManagementGroup()))));
        config.addPartitionGroup((PartitionGroupConfig)((RaftPartitionGroupConfig)((RaftPartitionGroupConfig)new RaftPartitionGroupConfig().setName(this.config.getDataGroup())).setPartitionSize(this.config.getPartitionSize()).setPartitions(this.config.getPartitions())).setMembers(this.config.getMembers()).setStorageConfig(new RaftStorageConfig().setDirectory(String.format("%s/%s", this.config.getDataPath(), this.config.getDataGroup()))));
    }

    public static class Type
    implements Profile.Type<ConsensusProfileConfig> {
        private static final String NAME = "consensus";

        public String name() {
            return NAME;
        }

        public ConsensusProfileConfig newConfig() {
            return new ConsensusProfileConfig();
        }

        @Override
        public Profile newProfile(ConsensusProfileConfig config) {
            return new ConsensusProfile(config);
        }
    }
}

