/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.deployment.generate;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.runtime.AdditionalJpaOperations;
import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.spring.data.deployment.DotNames;
import io.quarkus.spring.data.deployment.MethodNameParser;
import io.quarkus.spring.data.deployment.generate.AbstractMethodsAdder;
import io.quarkus.spring.data.runtime.TypesConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Transactional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class CustomQueryMethodsAdder
extends AbstractMethodsAdder {
    private static final String QUERY_VALUE_FIELD = "value";
    private static final String QUERY_COUNT_FIELD = "countQuery";
    private final IndexView index;

    public CustomQueryMethodsAdder(IndexView index) {
        this.index = index;
    }

    public void add(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, ClassInfo repositoryClassInfo, ClassInfo entityClassInfo) {
        for (MethodInfo method : repositoryClassInfo.methods()) {
            boolean isModifying;
            AnnotationInstance queryInstance = method.annotation(DotNames.SPRING_DATA_QUERY);
            if (queryInstance == null) continue;
            String methodName = method.name();
            String repositoryName = repositoryClassInfo.name().toString();
            this.verifyQueryAnnotation(queryInstance, methodName, repositoryName);
            String queryString = queryInstance.value(QUERY_VALUE_FIELD).asString().trim();
            if (queryString.contains("#{")) {
                throw new IllegalArgumentException("spEL expressions are not currently supported. Offending method is " + methodName + " of Repository " + repositoryName);
            }
            if (!(queryString.startsWith("select") || queryString.startsWith("SELECT") || queryString.startsWith("from") || queryString.startsWith("FROM") || queryString.startsWith("delete") || queryString.startsWith("DELETE") || queryString.startsWith("update") || queryString.startsWith("UPDATE"))) {
                throw new IllegalArgumentException("Unsupported query type in @Query. Offending method is " + methodName + " of Repository " + repositoryName);
            }
            boolean useNamedParams = method.annotation(DotNames.SPRING_DATA_PARAM) != null;
            List methodParameterTypes = method.parameters();
            String[] methodParameterTypesStr = new String[methodParameterTypes.size()];
            ArrayList<Integer> queryParameterIndexes = new ArrayList<Integer>(methodParameterTypes.size());
            Integer pageableParameterIndex = null;
            Integer sortParameterIndex = null;
            for (int i = 0; i < methodParameterTypes.size(); ++i) {
                DotName parameterType = ((Type)methodParameterTypes.get(i)).name();
                methodParameterTypesStr[i] = parameterType.toString();
                if (DotNames.SPRING_DATA_PAGEABLE.equals((Object)parameterType) || DotNames.SPRING_DATA_PAGE_REQUEST.equals((Object)parameterType)) {
                    if (pageableParameterIndex != null) {
                        throw new IllegalArgumentException("Method " + method.name() + " of Repository " + repositoryClassInfo + "has invalid parameters - only a single parameter of type" + DotNames.SPRING_DATA_PAGEABLE + " can be specified");
                    }
                    pageableParameterIndex = i;
                    continue;
                }
                if (DotNames.SPRING_DATA_SORT.equals((Object)parameterType)) {
                    if (sortParameterIndex != null) {
                        throw new IllegalArgumentException("Method " + method.name() + " of Repository " + repositoryClassInfo + "has invalid parameters - only a single parameter of type" + DotNames.SPRING_DATA_SORT + " can be specified");
                    }
                    sortParameterIndex = i;
                    continue;
                }
                if (useNamedParams) continue;
                queryParameterIndexes.add(i);
            }
            HashMap<String, Integer> namedParameterToIndex = new HashMap<String, Integer>();
            List annotations = method.annotations();
            for (AnnotationInstance annotation : annotations) {
                if (annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || !DotNames.SPRING_DATA_PARAM.equals((Object)annotation.name())) continue;
                namedParameterToIndex.put(annotation.value().asString(), Integer.valueOf(annotation.target().asMethodParameter().position()));
            }
            boolean bl = isModifying = method.annotation(DotNames.SPRING_DATA_MODIFYING) != null;
            if (isModifying && (sortParameterIndex != null || pageableParameterIndex != null)) {
                throw new IllegalArgumentException(method.name() + " of Repository " + repositoryClassInfo + " is meant to be a insert/update/delete query and therefore doesn't support Pageable and Sort method parameters");
            }
            DotName methodReturnTypeDotName = method.returnType().name();
            MethodCreator methodCreator = classCreator.getMethodCreator(method.name(), methodReturnTypeDotName.toString(), methodParameterTypesStr);
            Throwable throwable = null;
            try {
                ResultHandle panacheQuery;
                ResultHandle paramsArray;
                ResultHandle parameters;
                if (isModifying) {
                    methodCreator.addAnnotation(Transactional.class);
                    if (queryString.toLowerCase().startsWith("delete")) {
                        ResultHandle deleteCount;
                        if (!(DotNames.PRIMITIVE_LONG.equals((Object)methodReturnTypeDotName) || DotNames.LONG.equals((Object)methodReturnTypeDotName) || DotNames.VOID.equals((Object)methodReturnTypeDotName))) {
                            throw new IllegalArgumentException(method.name() + " of Repository " + repositoryClassInfo + " is meant to be a delete query and can therefore only have a void or long return type");
                        }
                        String deleteQueryString = queryString.substring("delete".length());
                        if (useNamedParams) {
                            parameters = this.generateParametersObject(namedParameterToIndex, methodCreator);
                            deleteCount = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"delete", Long.TYPE, (Class[])new Class[]{Class.class, String.class, Parameters.class}), new ResultHandle[]{methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis()), methodCreator.load(deleteQueryString), parameters});
                        } else {
                            paramsArray = this.generateParamsArray(queryParameterIndexes, methodCreator);
                            deleteCount = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"delete", Long.TYPE, (Class[])new Class[]{Class.class, String.class, Object[].class}), new ResultHandle[]{methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis()), methodCreator.load(deleteQueryString), paramsArray});
                        }
                        if (DotNames.VOID.equals((Object)methodReturnTypeDotName)) {
                            methodCreator.returnValue(null);
                        }
                        this.handleLongReturnValue((BytecodeCreator)methodCreator, deleteCount, methodReturnTypeDotName);
                        continue;
                    }
                    if (queryString.toLowerCase().startsWith("update")) {
                        ResultHandle updateCount;
                        if (!(DotNames.PRIMITIVE_INTEGER.equals((Object)methodReturnTypeDotName) || DotNames.INTEGER.equals((Object)methodReturnTypeDotName) || DotNames.VOID.equals((Object)methodReturnTypeDotName))) {
                            throw new IllegalArgumentException(method.name() + " of Repository " + repositoryClassInfo + " is meant to be an update query and can therefore only have a void or integer return type");
                        }
                        if (useNamedParams) {
                            ResultHandle parameters2 = this.generateParametersObject(namedParameterToIndex, methodCreator);
                            ResultHandle parametersMap = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Parameters.class, (String)"map", Map.class, (Class[])new Class[0]), parameters2, new ResultHandle[0]);
                            updateCount = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"executeUpdate", Integer.TYPE, (Class[])new Class[]{String.class, Map.class}), new ResultHandle[]{methodCreator.load(queryString), parametersMap});
                        } else {
                            ResultHandle paramsArray2 = this.generateParamsArray(queryParameterIndexes, methodCreator);
                            updateCount = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"executeUpdate", Integer.TYPE, (Class[])new Class[]{String.class, Object[].class}), new ResultHandle[]{methodCreator.load(queryString), paramsArray2});
                        }
                        if (DotNames.VOID.equals((Object)methodReturnTypeDotName)) {
                            methodCreator.returnValue(null);
                        }
                        this.handleIntegerReturnValue((BytecodeCreator)methodCreator, updateCount, methodReturnTypeDotName);
                        continue;
                    }
                    throw new IllegalArgumentException(method.name() + " of Repository " + repositoryClassInfo + " has been annotated with @Modifying but the @Query does not appear to be a delete or update query");
                }
                String countQueryString = "SELECT COUNT(*) " + queryString;
                if (queryInstance.value(QUERY_COUNT_FIELD) != null) {
                    countQueryString = queryInstance.value(QUERY_COUNT_FIELD).asString().trim();
                } else {
                    MethodNameParser methodNameParser = new MethodNameParser(repositoryClassInfo, this.index);
                    try {
                        MethodNameParser.Result parseResult = methodNameParser.parse(method);
                        if (MethodNameParser.QueryType.SELECT == parseResult.getQueryType()) {
                            countQueryString = "SELECT COUNT (*) " + parseResult.getQuery();
                        }
                    }
                    catch (Exception parseResult) {
                        // empty catch block
                    }
                }
                if (useNamedParams) {
                    parameters = this.generateParametersObject(namedParameterToIndex, methodCreator);
                    panacheQuery = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(AdditionalJpaOperations.class, (String)"find", PanacheQuery.class, (Class[])new Class[]{Class.class, String.class, String.class, Sort.class, Parameters.class}), new ResultHandle[]{methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis()), methodCreator.load(queryString), methodCreator.load(countQueryString), this.generateSort(sortParameterIndex, methodCreator), parameters});
                } else {
                    paramsArray = this.generateParamsArray(queryParameterIndexes, methodCreator);
                    panacheQuery = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(AdditionalJpaOperations.class, (String)"find", PanacheQuery.class, (Class[])new Class[]{Class.class, String.class, String.class, Sort.class, Object[].class}), new ResultHandle[]{methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis()), methodCreator.load(queryString), methodCreator.load(countQueryString), this.generateSort(sortParameterIndex, methodCreator), paramsArray});
                }
                this.generateFindQueryResultHandling(methodCreator, panacheQuery, pageableParameterIndex, repositoryClassInfo, entityClassInfo, methodReturnTypeDotName, null, method.name());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (methodCreator == null) continue;
                if (throwable != null) {
                    try {
                        methodCreator.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                methodCreator.close();
            }
        }
    }

    private void verifyQueryAnnotation(AnnotationInstance queryInstance, String methodName, String repositoryName) {
        List values = queryInstance.values();
        for (AnnotationValue value : values) {
            if (QUERY_VALUE_FIELD.equals(value.name()) || QUERY_COUNT_FIELD.equals(value.name())) continue;
            throw new IllegalArgumentException("Attribute " + value.name() + " of @Query is currently not supported. Offending method is " + methodName + " of Repository " + repositoryName);
        }
        if (queryInstance.value(QUERY_VALUE_FIELD) == null) {
            throw new IllegalArgumentException("'value' attribute must be specified on @Query annotation of method. Offending method is " + methodName + " of Repository " + repositoryName);
        }
    }

    private ResultHandle generateParamsArray(List<Integer> queryParameterIndexes, MethodCreator methodCreator) {
        ResultHandle paramsArray = methodCreator.newArray(Object.class, methodCreator.load(queryParameterIndexes.size()));
        for (int i = 0; i < queryParameterIndexes.size(); ++i) {
            methodCreator.writeArrayValue(paramsArray, methodCreator.load(i), methodCreator.getMethodParam(queryParameterIndexes.get(i).intValue()));
        }
        return paramsArray;
    }

    private ResultHandle generateParametersObject(Map<String, Integer> namedParameterToIndex, MethodCreator methodCreator) {
        ResultHandle parameters = methodCreator.newInstance(MethodDescriptor.ofConstructor(Parameters.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (Map.Entry<String, Integer> entry : namedParameterToIndex.entrySet()) {
            methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Parameters.class, (String)"and", Parameters.class, (Class[])new Class[]{String.class, Object.class}), parameters, new ResultHandle[]{methodCreator.load(entry.getKey()), methodCreator.getMethodParam(entry.getValue().intValue())});
        }
        return parameters;
    }

    private ResultHandle generateSort(Integer sortParameterIndex, MethodCreator methodCreator) {
        ResultHandle sort = methodCreator.loadNull();
        if (sortParameterIndex != null) {
            sort = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(TypesConverter.class, (String)"toPanacheSort", Sort.class, (Class[])new Class[]{org.springframework.data.domain.Sort.class}), new ResultHandle[]{methodCreator.getMethodParam(sortParameterIndex.intValue())});
        }
        return sort;
    }
}

