/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.rest.data.panache.runtime;

import com.mongodb.MongoWriteException;
import io.quarkus.rest.data.panache.RestDataPanacheException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.jboss.logging.Logger;

public class RestDataPanacheExceptionMapper
implements ExceptionMapper<RestDataPanacheException> {
    private static final String DUPLICATE_KEY_ERROR_CODE = "E11000";
    private static final Logger LOGGER = Logger.getLogger(RestDataPanacheExceptionMapper.class);

    public Response toResponse(RestDataPanacheException exception) {
        LOGGER.warnf((Throwable)exception, "Mapping an unhandled %s", (Object)RestDataPanacheException.class.getSimpleName());
        return this.throwableToResponse((Throwable)exception, exception.getMessage());
    }

    private Response throwableToResponse(Throwable throwable, String message) {
        if (throwable instanceof MongoWriteException && throwable.getMessage().contains(DUPLICATE_KEY_ERROR_CODE)) {
            return Response.status((int)Response.Status.CONFLICT.getStatusCode(), (String)message).build();
        }
        if (throwable.getCause() != null) {
            return this.throwableToResponse(throwable.getCause(), message);
        }
        return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (String)message).build();
    }
}

