/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.rest.data.panache.deployment;

import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.mongodb.rest.data.panache.deployment.DataAccessImplementor;
import io.quarkus.mongodb.rest.data.panache.deployment.EntityClassHelper;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Sort;
import io.quarkus.runtime.util.HashUtil;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.jandex.FieldInfo;
import org.jboss.logging.Logger;

class ResourceImplementor {
    private static final Logger LOGGER = Logger.getLogger(ResourceImplementor.class);
    private final EntityClassHelper entityClassHelper;

    ResourceImplementor(EntityClassHelper entityClassHelper) {
        this.entityClassHelper = entityClassHelper;
    }

    String implement(ClassOutput classOutput, DataAccessImplementor dataAccessImplementor, String resourceType, String entityType) {
        String className = resourceType + "Impl_" + HashUtil.sha1((String)resourceType);
        LOGGER.tracef("Starting generation of '%s'", (Object)className);
        ClassCreator classCreator = ClassCreator.builder().classOutput(classOutput).className(className).interfaces(new String[]{resourceType}).build();
        classCreator.addAnnotation(ApplicationScoped.class);
        this.implementList(classCreator, dataAccessImplementor);
        this.implementListPageCount(classCreator, dataAccessImplementor);
        this.implementGet(classCreator, dataAccessImplementor);
        this.implementAdd(classCreator, dataAccessImplementor);
        this.implementUpdate(classCreator, dataAccessImplementor, entityType);
        this.implementDelete(classCreator, dataAccessImplementor);
        classCreator.close();
        LOGGER.tracef("Completed generation of '%s'", (Object)className);
        return className;
    }

    private void implementList(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("list", List.class, new Class[]{Page.class, Sort.class});
        ResultHandle page = methodCreator.getMethodParam(0);
        ResultHandle sort = methodCreator.getMethodParam(1);
        ResultHandle columns = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Sort.class, (String)"getColumns", List.class, (Class[])new Class[0]), sort, new ResultHandle[0]);
        ResultHandle isEmptySort = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"isEmpty", Boolean.TYPE, (Class[])new Class[0]), columns, new ResultHandle[0]);
        BranchResult isEmptySortBranch = methodCreator.ifTrue(isEmptySort);
        isEmptySortBranch.trueBranch().returnValue(dataAccessImplementor.findAll(isEmptySortBranch.trueBranch(), page));
        isEmptySortBranch.falseBranch().returnValue(dataAccessImplementor.findAll(isEmptySortBranch.falseBranch(), page, sort));
        methodCreator.close();
    }

    private void implementListPageCount(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("$$_page_count_list", Integer.TYPE, new Class[]{Page.class});
        ResultHandle page = methodCreator.getMethodParam(0);
        methodCreator.returnValue(dataAccessImplementor.pageCount((BytecodeCreator)methodCreator, page));
        methodCreator.close();
    }

    private void implementGet(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("get", Object.class, new Class[]{Object.class});
        ResultHandle id = methodCreator.getMethodParam(0);
        methodCreator.returnValue(dataAccessImplementor.findById((BytecodeCreator)methodCreator, id));
        methodCreator.close();
    }

    private void implementAdd(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("add", Object.class, new Class[]{Object.class});
        ResultHandle entity = methodCreator.getMethodParam(0);
        methodCreator.returnValue(dataAccessImplementor.persist((BytecodeCreator)methodCreator, entity));
        methodCreator.close();
    }

    private void implementUpdate(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor, String entityType) {
        MethodCreator methodCreator = classCreator.getMethodCreator("update", Object.class, new Class[]{Object.class, Object.class});
        ResultHandle id = methodCreator.getMethodParam(0);
        ResultHandle entity = methodCreator.getMethodParam(1);
        this.setId((BytecodeCreator)methodCreator, entityType, entity, id);
        methodCreator.returnValue(dataAccessImplementor.persistOrUpdate((BytecodeCreator)methodCreator, entity));
        methodCreator.close();
    }

    private void implementDelete(ClassCreator classCreator, DataAccessImplementor dataAccessImplementor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("delete", Boolean.TYPE, new Class[]{Object.class});
        ResultHandle id = methodCreator.getMethodParam(0);
        methodCreator.returnValue(dataAccessImplementor.deleteById((BytecodeCreator)methodCreator, id));
        methodCreator.close();
    }

    private void setId(BytecodeCreator creator, String entityType, ResultHandle entity, ResultHandle id) {
        FieldInfo idField = this.entityClassHelper.getIdField(entityType);
        MethodDescriptor idSetter = this.entityClassHelper.getSetter(entityType, idField);
        if (idSetter == null) {
            creator.writeInstanceField(idField, entity, id);
        } else {
            creator.invokeVirtualMethod(idSetter, entity, new ResultHandle[]{id});
        }
    }
}

