/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.utils.Strings;
import io.quarkus.kubernetes.deployment.PlatformConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class KubernetesConfigUtil {
    private static final String DEKORATE_PREFIX = "dekorate.";
    private static final String QUARKUS_PREFIX = "quarkus.";
    private static final Set<String> ALLOWED_GENERATORS = new HashSet<String>(Arrays.asList("kubernetes", "openshift", "knative", "docker", "s2i"));
    private static final String EXPOSE_PROPERTY_NAME = "expose";
    private static final String[] EXPOSABLE_GENERATORS = new String[]{"openshift", "kubernetes"};
    private static final Logger log = Logger.getLogger(KubernetesConfigUtil.class);

    public static List<String> getUserSpecifiedDeploymentTargets() {
        Config config = ConfigProvider.getConfig();
        String configValue = config.getOptionalValue("quarkus.kubernetes.deployment-target", String.class).orElse(config.getOptionalValue("kubernetes.deployment.target", String.class).orElse(""));
        if (configValue.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(configValue.split(",")).map(String::trim).map(String::toLowerCase).collect(Collectors.toList());
    }

    public static Map<String, Object> toMap(PlatformConfiguration ... platformConfigurations) {
        Config config = ConfigProvider.getConfig();
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> quarkusPrefixed = new HashMap<String, Object>();
        Arrays.stream(platformConfigurations).forEach(p -> {
            p.getPartOf().ifPresent(g -> quarkusPrefixed.put(DEKORATE_PREFIX + p.getConfigName() + ".part-of", g));
            p.getName().ifPresent(n -> quarkusPrefixed.put(DEKORATE_PREFIX + p.getConfigName() + ".name", n));
            p.getVersion().ifPresent(v -> quarkusPrefixed.put(DEKORATE_PREFIX + p.getConfigName() + ".version", v));
        });
        Map<String, Object> unPrefixed = StreamSupport.stream(config.getPropertyNames().spliterator(), false).filter(k -> ALLOWED_GENERATORS.contains(KubernetesConfigUtil.generatorName(k))).filter(k -> config.getOptionalValue(k, String.class).isPresent()).collect(Collectors.toMap((? super T k) -> DEKORATE_PREFIX + k, (? super T k) -> config.getValue(k, String.class)));
        for (String generator : ALLOWED_GENERATORS) {
            String oldKey = DEKORATE_PREFIX + generator + ".group";
            String newKey = DEKORATE_PREFIX + generator + ".part-of";
            if (!unPrefixed.containsKey(oldKey)) continue;
            unPrefixed.put(newKey, unPrefixed.get(oldKey));
        }
        KubernetesConfigUtil.handleExpose(config, unPrefixed, platformConfigurations);
        result.putAll(unPrefixed);
        result.putAll(quarkusPrefixed);
        result.putAll(KubernetesConfigUtil.toS2iProperties(quarkusPrefixed));
        return result;
    }

    @Deprecated
    private static void handleExpose(Config config, Map<String, Object> unPrefixed, PlatformConfiguration ... platformConfigurations) {
        block0: for (String generator : EXPOSABLE_GENERATORS) {
            boolean unprefixedExpose = config.getOptionalValue(generator + ".expose", Boolean.class).orElse(false);
            boolean prefixedExpose = config.getOptionalValue(QUARKUS_PREFIX + generator + ".expose", Boolean.class).orElse(false);
            if (!unprefixedExpose && !prefixedExpose) continue;
            if (generator == "kubernetes") {
                log.warn((Object)"Usage of quarkus.kubernetes.expose is deprecated in favor of quarkus.kubernetes.ingress.expose");
            } else {
                log.warn((Object)"Usage of quarkus.openshift.expose is deprecated in favor of quarkus.openshift.route.expose");
            }
            unPrefixed.put(DEKORATE_PREFIX + generator + ".expose", true);
            for (PlatformConfiguration platformConfiguration : platformConfigurations) {
                if (!platformConfiguration.getConfigName().equals(generator)) continue;
                platformConfiguration.getHost().ifPresent(h -> {
                    unPrefixed.put(DEKORATE_PREFIX + generator + ".host", h);
                    if (generator == "kubernetes") {
                        log.warn((Object)"Usage of quarkus.kubernetes.host is deprecated in favor of quarkus.kubernetes.ingress.host");
                    } else {
                        log.warn((Object)"Usage of quarkus.openshift.host is deprecated in favor of quarkus.openshift.route.host");
                    }
                });
                continue block0;
            }
        }
    }

    private static String generatorName(String key) {
        if (Strings.isNullOrEmpty((String)key) || !key.contains(".")) {
            return null;
        }
        return key.substring(0, key.indexOf("."));
    }

    private static Map<String, Object> toS2iProperties(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        map.forEach((k, v) -> {
            if (k.contains("openshift")) {
                result.put(k.replaceAll("openshift", "s2i"), v);
            }
        });
        return result;
    }
}

