/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.rest.data.panache.deployment;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.hibernate.orm.panache.PanacheEntityBase;
import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Sort;
import io.quarkus.rest.data.panache.deployment.DataAccessImplementor;
import java.util.List;
import javax.persistence.EntityManager;

final class EntityDataAccessImplementor
implements DataAccessImplementor {
    private final String entityClassName;

    EntityDataAccessImplementor(String entityClassName) {
        this.entityClassName = entityClassName;
    }

    public ResultHandle findById(BytecodeCreator creator, ResultHandle id) {
        return creator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)this.entityClassName, (String)"findById", PanacheEntityBase.class, (Object[])new Object[]{Object.class}), new ResultHandle[]{id});
    }

    public ResultHandle listAll(BytecodeCreator creator, ResultHandle sort) {
        return creator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)this.entityClassName, (String)"listAll", List.class, (Object[])new Object[]{Sort.class}), new ResultHandle[]{sort});
    }

    public ResultHandle findAll(BytecodeCreator creator, ResultHandle page, ResultHandle sort) {
        ResultHandle query = creator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)this.entityClassName, (String)"findAll", PanacheQuery.class, (Object[])new Object[]{Sort.class}), new ResultHandle[]{sort});
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{Page.class}), query, new ResultHandle[]{page});
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", List.class, (Class[])new Class[0]), query, new ResultHandle[0]);
    }

    public ResultHandle persist(BytecodeCreator creator, ResultHandle entity) {
        creator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)this.entityClassName, (String)"persist", Void.TYPE, (Object[])new Object[0]), entity, new ResultHandle[0]);
        return entity;
    }

    public ResultHandle update(BytecodeCreator creator, ResultHandle entity) {
        ResultHandle entityManager = creator.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"getEntityManager", EntityManager.class, (Class[])new Class[0]), new ResultHandle[0]);
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(EntityManager.class, (String)"merge", Object.class, (Class[])new Class[]{Object.class}), entityManager, new ResultHandle[]{entity});
    }

    public ResultHandle deleteById(BytecodeCreator creator, ResultHandle id) {
        return creator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)this.entityClassName, (String)"deleteById", Boolean.TYPE, (Object[])new Object[]{Object.class}), new ResultHandle[]{id});
    }

    public ResultHandle pageCount(BytecodeCreator creator, ResultHandle page) {
        ResultHandle query = creator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)this.entityClassName, (String)"findAll", PanacheQuery.class, (Object[])new Object[0]), new ResultHandle[0]);
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{Page.class}), query, new ResultHandle[]{page});
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"pageCount", Integer.TYPE, (Class[])new Class[0]), query, new ResultHandle[0]);
    }
}

