/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.rest.data.panache.deployment;

import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.rest.data.panache.deployment.RestDataEntityInfo;
import javax.persistence.Id;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

final class RestDataEntityInfoProvider {
    private final IndexView index;

    RestDataEntityInfoProvider(IndexView index) {
        this.index = index;
    }

    RestDataEntityInfo get(String entityType, String idType) {
        ClassInfo classInfo = this.index.getClassByName(DotName.createSimple((String)entityType));
        FieldInfo idField = this.getIdField(classInfo);
        return new RestDataEntityInfo(classInfo.toString(), idType, idField, this.getSetter(classInfo, idField));
    }

    private FieldInfo getIdField(ClassInfo classInfo) {
        ClassInfo tmpClassInfo = classInfo;
        while (tmpClassInfo != null) {
            for (FieldInfo field : tmpClassInfo.fields()) {
                if (!field.hasAnnotation(DotName.createSimple((String)Id.class.getName()))) continue;
                return field;
            }
            if (classInfo.superName() != null) {
                tmpClassInfo = this.index.getClassByName(classInfo.superName());
                continue;
            }
            tmpClassInfo = null;
        }
        throw new IllegalArgumentException("Couldn't find id field of " + classInfo);
    }

    private MethodDescriptor getSetter(ClassInfo entityClass, FieldInfo field) {
        if (entityClass == null) {
            return null;
        }
        MethodInfo methodInfo = entityClass.method(JavaBeanUtil.getSetterName((String)field.name()), new Type[]{field.type()});
        if (methodInfo != null) {
            return MethodDescriptor.of((MethodInfo)methodInfo);
        }
        if (entityClass.superName() != null) {
            return this.getSetter(this.index.getClassByName(entityClass.superName()), field);
        }
        return null;
    }
}

