/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.kotlin.deployment;

import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.hibernate.orm.panache.kotlin.deployment.KotlinPanacheEntityClassVisitor;
import io.quarkus.hibernate.orm.panache.kotlin.deployment.KotlinPanacheResourceProcessor;
import io.quarkus.hibernate.orm.panache.kotlin.runtime.JpaOperations;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.persistence.Transient;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;

public class KotlinPanacheEntityEnhancer
extends PanacheEntityEnhancer<MetamodelInfo<EntityModel<EntityField>>> {
    private static final String JPA_OPERATIONS_NAME = JpaOperations.class.getName();
    public static final String JPA_OPERATIONS_BINARY_NAME = JPA_OPERATIONS_NAME.replace('.', '/');
    private static final DotName DOTNAME_TRANSIENT = DotName.createSimple((String)Transient.class.getName());

    public KotlinPanacheEntityEnhancer(IndexView index, List<PanacheMethodCustomizer> methodCustomizers) {
        super(index, KotlinPanacheResourceProcessor.PANACHE_ENTITY_BASE_DOTNAME, methodCustomizers);
        this.modelInfo = new MetamodelInfo();
    }

    public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
        return new KotlinPanacheEntityClassVisitor(className, outputClassVisitor, (MetamodelInfo<EntityModel<EntityField>>)this.modelInfo, this.panacheEntityBaseClassInfo, this.indexView.getClassByName(DotName.createSimple((String)className)), this.methodCustomizers);
    }

    public void collectFields(ClassInfo classInfo) {
        EntityModel entityModel = new EntityModel(classInfo);
        for (FieldInfo fieldInfo : classInfo.fields()) {
            String name = fieldInfo.name();
            if (!Modifier.isPublic(fieldInfo.flags()) || Modifier.isStatic(fieldInfo.flags()) || fieldInfo.hasAnnotation(DOTNAME_TRANSIENT)) continue;
            entityModel.addField(new EntityField(name, DescriptorUtils.typeToString((Type)fieldInfo.type())));
        }
        this.modelInfo.addEntityModel(entityModel);
    }
}

