/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.kotlin.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.hibernate.orm.deployment.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateEnhancersRegisteredBuildItem;
import io.quarkus.hibernate.orm.panache.kotlin.PanacheCompanion;
import io.quarkus.hibernate.orm.panache.kotlin.PanacheEntity;
import io.quarkus.hibernate.orm.panache.kotlin.PanacheEntityBase;
import io.quarkus.hibernate.orm.panache.kotlin.PanacheRepository;
import io.quarkus.hibernate.orm.panache.kotlin.PanacheRepositoryBase;
import io.quarkus.hibernate.orm.panache.kotlin.deployment.KotlinPanacheCompanionEnhancer;
import io.quarkus.hibernate.orm.panache.kotlin.deployment.KotlinPanacheEntityEnhancer;
import io.quarkus.hibernate.orm.panache.kotlin.deployment.KotlinPanacheRepositoryEnhancer;
import io.quarkus.hibernate.orm.panache.kotlin.runtime.JpaOperations;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheFieldAccessEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizerBuildItem;
import io.quarkus.panache.common.deployment.PanacheRepositoryEnhancer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;

public final class KotlinPanacheResourceProcessor {
    private static final Set<DotName> UNREMOVABLE_BEANS = Collections.singleton(DotName.createSimple((String)EntityManager.class.getName()));
    static final String JPA_OPERATIONS = DotName.createSimple((String)JpaOperations.class.getName()).toString().replace(".", "/");
    static final DotName PANACHE_REPOSITORY_BASE_DOTNAME = DotName.createSimple((String)PanacheRepositoryBase.class.getName());
    static final DotName PANACHE_REPOSITORY_DOTNAME = DotName.createSimple((String)PanacheRepository.class.getName());
    static final DotName PANACHE_ENTITY_BASE_DOTNAME = DotName.createSimple((String)PanacheEntityBase.class.getName());
    static final DotName PANACHE_COMPANION_DOTNAME = DotName.createSimple((String)PanacheCompanion.class.getName());
    static final DotName PANACHE_ENTITY_DOTNAME = DotName.createSimple((String)PanacheEntity.class.getName());
    static final String PANACHE_REPOSITORY_BASE_SIGNATURE = KotlinPanacheResourceProcessor.toBinarySignature(PanacheRepositoryBase.class);
    static final String PANACHE_REPOSITORY_SIGNATURE = KotlinPanacheResourceProcessor.toBinarySignature(PanacheRepository.class);
    static final String PANACHE_COMPANION_SIGNATURE = KotlinPanacheResourceProcessor.toBinarySignature(PanacheCompanion.class);
    static final String PANACHE_ENTITY_SIGNATURE = KotlinPanacheResourceProcessor.toBinarySignature(PanacheEntity.class);
    static final String ID_TYPE_SIGNATURE = KotlinPanacheResourceProcessor.toBinarySignature(Long.class);
    static final String OBJECT_SIGNATURE = KotlinPanacheResourceProcessor.toBinarySignature(Object.class);
    static final String CLASS_SIGNATURE = KotlinPanacheResourceProcessor.toBinarySignature(Class.class);
    static final Type CLASS_TYPE = Type.getType(Class.class);
    static final Type OBJECT_TYPE = Type.getType(Object.class);
    static final List<Type> REPOSITORY_TYPES = Arrays.asList(Type.getType(PanacheRepositoryBase.class), Type.getType(PanacheRepository.class));
    static final List<Type> ENTITY_TYPES = Arrays.asList(Type.getType(PanacheEntityBase.class), Type.getType(PanacheEntity.class), Type.getType(PanacheCompanion.class));
    public static final List<Type> PRIMITIVE_TYPES = Arrays.asList(Type.getType(Void.class), Type.getType(Boolean.class), Type.getType(Character.class), Type.getType(Byte.class), Type.getType(Short.class), Type.getType(Integer.class), Type.getType(Float.class), Type.getType(Long.class));

    static Type sanitize(Type[] argumentTypes) {
        Type primitiveReplaced = null;
        for (int i = 0; i < argumentTypes.length; ++i) {
            if (REPOSITORY_TYPES.contains(argumentTypes[i])) {
                argumentTypes[i] = CLASS_TYPE;
                continue;
            }
            if (ENTITY_TYPES.contains(argumentTypes[i])) {
                argumentTypes[i] = OBJECT_TYPE;
                continue;
            }
            if (argumentTypes[i].getInternalName().length() != 1) continue;
            primitiveReplaced = argumentTypes[i];
            argumentTypes[i] = OBJECT_TYPE;
        }
        return primitiveReplaced;
    }

    static Type autobox(Type primitive) {
        return PRIMITIVE_TYPES.get(primitive.getSort());
    }

    @NotNull
    static String toBinarySignature(Class<?> type) {
        return Type.getType(type).getDescriptor();
    }

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem("hibernate-orm-panache-kotlin");
    }

    @BuildStep
    List<AdditionalJpaModelBuildItem> produceModel() {
        return Collections.singletonList(new AdditionalJpaModelBuildItem(PanacheEntity.class));
    }

    @BuildStep
    UnremovableBeanBuildItem ensureBeanLookupAvailable() {
        return new UnremovableBeanBuildItem((Predicate)new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo beanInfo) {
                for (org.jboss.jandex.Type t : beanInfo.getTypes()) {
                    if (!UNREMOVABLE_BEANS.contains(t.name())) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @BuildStep
    void build(CombinedIndexBuildItem index, ApplicationIndexBuildItem applicationIndex, BuildProducer<BytecodeTransformerBuildItem> transformers, HibernateEnhancersRegisteredBuildItem hibernateMarker, List<PanacheMethodCustomizerBuildItem> methodCustomizersBuildItems) {
        List<PanacheMethodCustomizer> methodCustomizers = methodCustomizersBuildItems.stream().map(bi -> bi.getMethodCustomizer()).collect(Collectors.toList());
        KotlinPanacheRepositoryEnhancer daoEnhancer = new KotlinPanacheRepositoryEnhancer(index.getIndex());
        HashSet<String> daoClasses = new HashSet<String>();
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(PANACHE_REPOSITORY_BASE_DOTNAME)) {
            if (classInfo.name().equals((Object)PANACHE_REPOSITORY_DOTNAME) || PanacheRepositoryEnhancer.skipRepository((ClassInfo)classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(PANACHE_REPOSITORY_DOTNAME)) {
            if (PanacheRepositoryEnhancer.skipRepository((ClassInfo)classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
        }
        for (String daoClass : daoClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(daoClass, (BiFunction)((Object)daoEnhancer)));
        }
        KotlinPanacheCompanionEnhancer companionEnhancer = new KotlinPanacheCompanionEnhancer(index.getIndex(), methodCustomizers);
        KotlinPanacheEntityEnhancer entityEnhancer = new KotlinPanacheEntityEnhancer(index.getIndex(), methodCustomizers);
        HashSet<String> modelClasses = new HashSet<String>();
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(PANACHE_COMPANION_DOTNAME)) {
            if (classInfo.name().equals((Object)PANACHE_ENTITY_DOTNAME) || !modelClasses.add(classInfo.name().toString())) continue;
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.name().toString(), (BiFunction)((Object)companionEnhancer)));
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownSubclasses(PANACHE_ENTITY_DOTNAME)) {
            if (classInfo.name().equals((Object)PANACHE_ENTITY_DOTNAME) || !modelClasses.add(classInfo.name().toString())) continue;
            entityEnhancer.collectFields(classInfo);
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.name().toString(), (BiFunction)((Object)entityEnhancer)));
        }
        MetamodelInfo modelInfo = entityEnhancer.getModelInfo();
        if (modelInfo.hasEntities()) {
            PanacheFieldAccessEnhancer panacheFieldAccessEnhancer = new PanacheFieldAccessEnhancer(modelInfo);
            for (ClassInfo classInfo : applicationIndex.getIndex().getKnownClasses()) {
                String className = classInfo.name().toString();
                if (modelClasses.contains(className)) continue;
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(className, (BiFunction)panacheFieldAccessEnhancer));
            }
        }
    }
}

