/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.kotlin.deployment;

import io.quarkus.hibernate.orm.panache.kotlin.deployment.KotlinPanacheResourceProcessor;
import io.quarkus.panache.common.deployment.JandexUtil;
import io.quarkus.panache.common.deployment.PanacheRepositoryEnhancer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class KotlinPanacheRepositoryClassVisitor
extends ClassVisitor {
    public static final Pattern DEFAULT_IMPLS = Pattern.compile(".*PanacheRepository.*\\$DefaultImpls");
    private final Map<String, MethodInfo> bridgeMethods = new TreeMap<String, MethodInfo>();
    private final IndexView indexView;
    private Type entityType;
    private String entitySignature;
    protected Map<String, String> typeArguments = new HashMap<String, String>();
    private String idBinaryType;
    private String idSignature;

    public KotlinPanacheRepositoryClassVisitor(String className, ClassVisitor outputClassVisitor, IndexView indexView) {
        super(524288, outputClassVisitor);
        this.indexView = indexView;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        String repositoryClassName = name.replace('/', '.');
        String[] foundTypeArguments = PanacheRepositoryEnhancer.PanacheRepositoryClassVisitor.findEntityTypeArgumentsForPanacheRepository((IndexView)this.indexView, (String)repositoryClassName, (DotName)KotlinPanacheResourceProcessor.PANACHE_REPOSITORY_BASE_DOTNAME);
        String entityBinaryType = foundTypeArguments[0];
        this.entitySignature = "L" + entityBinaryType + ";";
        this.entityType = Type.getType((String)this.entitySignature);
        this.idBinaryType = foundTypeArguments[1];
        this.idSignature = "L" + this.idBinaryType + ";";
        this.typeArguments.put("Entity", this.entitySignature);
        this.typeArguments.put("Id", this.idSignature);
        this.indexView.getClassByName(DotName.createSimple((String)repositoryClassName)).methods().forEach(method -> {
            if (method.hasAnnotation(JandexUtil.DOTNAME_GENERATE_BRIDGE)) {
                this.bridgeMethods.put(method.name() + JandexUtil.getDescriptor((MethodInfo)method, m -> this.typeArguments.get(m)), (MethodInfo)method);
            }
        });
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        if (this.bridgeMethods.get(name + descriptor) != null) {
            final Type[] argumentTypes = Type.getArgumentTypes((String)descriptor);
            int primitive = -1;
            for (int i = 0; i < argumentTypes.length; ++i) {
                if (argumentTypes[i].getInternalName().length() != 1) continue;
                primitive = i;
            }
            final int finalPrimitive = primitive;
            mv = new MethodVisitor(524288, mv){

                public void visitVarInsn(int opcode, int var) {
                    if (opcode == 25 && var == 0) {
                        this.visitLdcInsn(KotlinPanacheRepositoryClassVisitor.this.entityType);
                    } else {
                        super.visitVarInsn(opcode, var);
                        if (opcode == 22 && var == finalPrimitive + 1) {
                            Type wrapper = KotlinPanacheResourceProcessor.autobox(argumentTypes[finalPrimitive]);
                            super.visitMethodInsn(184, wrapper.getInternalName(), "valueOf", Type.getMethodDescriptor((Type)wrapper, (Type[])new Type[]{argumentTypes[finalPrimitive]}), false);
                        }
                    }
                }

                public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                    if (opcode == 184 && DEFAULT_IMPLS.matcher(owner).matches()) {
                        owner = KotlinPanacheResourceProcessor.JPA_OPERATIONS;
                        Type[] arguments = Type.getArgumentTypes((String)descriptor);
                        KotlinPanacheResourceProcessor.sanitize(arguments);
                        descriptor = Type.getMethodDescriptor((Type)Type.getReturnType((String)descriptor), (Type[])arguments);
                    }
                    super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                }
            };
        }
        return mv;
    }
}

