/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.kotlin.deployment;

import io.quarkus.hibernate.orm.panache.kotlin.deployment.KotlinPanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import java.util.List;
import java.util.StringJoiner;
import org.jboss.jandex.ClassInfo;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class KotlinPanacheEntityClassVisitor
extends PanacheEntityEnhancer.PanacheEntityClassVisitor<EntityField> {
    private String entityBinaryType;
    private Type entityType;

    public KotlinPanacheEntityClassVisitor(String className, ClassVisitor outputClassVisitor, MetamodelInfo<EntityModel<EntityField>> modelInfo, ClassInfo panacheEntityBaseClassInfo, ClassInfo entityInfo, List<PanacheMethodCustomizer> methodCustomizers) {
        super(className, outputClassVisitor, modelInfo, panacheEntityBaseClassInfo, entityInfo, methodCustomizers);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        String className = name.replace('.', '/');
        this.entityBinaryType = className.replace("$Companion", "");
        this.entityType = Type.getType((String)("L" + this.entityBinaryType + ";"));
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        int updated = access;
        if (name.startsWith("get") || name.startsWith("set")) {
            updated &= 0xFFFFFFEF;
        }
        return super.visitMethod(updated, name, descriptor, signature, exceptions);
    }

    protected String getModelDescriptor() {
        return "Ljava/lang/Class;";
    }

    protected String getPanacheOperationsBinaryName() {
        return KotlinPanacheEntityEnhancer.JPA_OPERATIONS_BINARY_NAME;
    }

    protected void injectModel(MethodVisitor mv) {
        mv.visitLdcInsn((Object)this.entityType);
    }

    protected void generateAccessors() {
    }

    protected void generateAccessorSetField(MethodVisitor mv, EntityField field) {
        throw new UnsupportedOperationException("generateAccessorSetField has not yet been implemented.");
    }

    protected void generateAccessorGetField(MethodVisitor mv, EntityField field) {
        throw new UnsupportedOperationException("generateAccessorGetField has not yet been implemented.");
    }

    public String toString() {
        return new StringJoiner(", ", KotlinPanacheEntityClassVisitor.class.getSimpleName() + "[", "]").add(this.entityBinaryType).toString();
    }
}

