/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.kotlin.deployment;

import io.quarkus.hibernate.orm.panache.kotlin.deployment.KotlinPanacheResourceProcessor;
import io.quarkus.panache.common.deployment.JandexUtil;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class KotlinPanacheCompanionClassVisitor
extends ClassVisitor {
    private static final String DEFAULT_IMPLS = "io/quarkus/hibernate/orm/panache/kotlin/PanacheCompanion$DefaultImpls";
    private final Map<String, MethodInfo> bridgeMethods = new TreeMap<String, MethodInfo>();
    private String entityBinaryType;
    private String entitySignature;
    private Type entityType;

    public KotlinPanacheCompanionClassVisitor(ClassVisitor outputClassVisitor, ClassInfo entityInfo) {
        super(524288, outputClassVisitor);
        entityInfo.methods().forEach(method -> {
            if (method.hasAnnotation(JandexUtil.DOTNAME_GENERATE_BRIDGE)) {
                this.bridgeMethods.put(method.name() + JandexUtil.getDescriptor((MethodInfo)method, m -> null), (MethodInfo)method);
            }
        });
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        String className = name.replace('.', '/');
        this.entityBinaryType = className.replace("$Companion", "");
        this.entitySignature = "L" + this.entityBinaryType + ";";
        this.entityType = Type.getType((String)this.entitySignature);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        if (this.bridgeMethods.get(name + descriptor) != null) {
            mv = new MethodVisitor(524288, mv){

                public void visitVarInsn(int opcode, int var) {
                    if (opcode == 25 && var == 0) {
                        this.visitLdcInsn(KotlinPanacheCompanionClassVisitor.this.entityType);
                    } else {
                        super.visitVarInsn(opcode, var);
                    }
                }

                public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                    if (opcode == 184 && owner.equals(KotlinPanacheCompanionClassVisitor.DEFAULT_IMPLS)) {
                        String replace = descriptor.replace(KotlinPanacheResourceProcessor.PANACHE_ENTITY_SIGNATURE, KotlinPanacheResourceProcessor.OBJECT_SIGNATURE).replace(KotlinPanacheResourceProcessor.PANACHE_COMPANION_SIGNATURE, KotlinPanacheResourceProcessor.CLASS_SIGNATURE);
                        super.visitMethodInsn(opcode, KotlinPanacheResourceProcessor.JPA_OPERATIONS, name, replace, isInterface);
                    } else {
                        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                    }
                }
            };
        }
        return mv;
    }

    public void visitEnd() {
        if (this.cv != null) {
            this.cv.visitEnd();
        }
    }

    public String toString() {
        return new StringJoiner(", ", KotlinPanacheCompanionClassVisitor.class.getSimpleName() + "[", "]").add(this.entityBinaryType).toString();
    }
}

