/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.kotlin.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.hibernate.orm.deployment.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateEnhancersRegisteredBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaModelPersistenceUnitMappingBuildItem;
import io.quarkus.hibernate.orm.panache.kotlin.PanacheCompanion;
import io.quarkus.hibernate.orm.panache.kotlin.PanacheEntity;
import io.quarkus.hibernate.orm.panache.kotlin.PanacheEntityBase;
import io.quarkus.hibernate.orm.panache.kotlin.PanacheRepository;
import io.quarkus.hibernate.orm.panache.kotlin.PanacheRepositoryBase;
import io.quarkus.hibernate.orm.panache.kotlin.deployment.KotlinPanacheCompanionEnhancer;
import io.quarkus.hibernate.orm.panache.kotlin.deployment.KotlinPanacheEntityEnhancer;
import io.quarkus.hibernate.orm.panache.kotlin.deployment.KotlinPanacheRepositoryEnhancer;
import io.quarkus.hibernate.orm.panache.kotlin.runtime.JpaOperations;
import io.quarkus.hibernate.orm.panache.kotlin.runtime.PanacheKotlinHibernateOrmRecorder;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheFieldAccessEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizerBuildItem;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Transient;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;

public final class KotlinPanacheResourceProcessor {
    private static final Set<DotName> UNREMOVABLE_BEANS = Collections.singleton(DotName.createSimple((String)EntityManager.class.getName()));
    static final String JPA_OPERATIONS = DotName.createSimple((String)JpaOperations.class.getName()).toString().replace(".", "/");
    static final DotName PANACHE_REPOSITORY_BASE = DotName.createSimple((String)PanacheRepositoryBase.class.getName());
    static final DotName PANACHE_REPOSITORY = DotName.createSimple((String)PanacheRepository.class.getName());
    static final DotName PANACHE_ENTITY_BASE = DotName.createSimple((String)PanacheEntityBase.class.getName());
    static final DotName PANACHE_ENTITY = DotName.createSimple((String)PanacheEntity.class.getName());
    static final DotName PANACHE_COMPANION = DotName.createSimple((String)PanacheCompanion.class.getName());
    static final String PANACHE_ENTITY_BASE_SIGNATURE = KotlinPanacheResourceProcessor.toBinarySignature(PanacheEntityBase.class);
    static final String PANACHE_ENTITY_SIGNATURE = KotlinPanacheResourceProcessor.toBinarySignature(PanacheEntity.class);
    static final String PANACHE_COMPANION_SIGNATURE = KotlinPanacheResourceProcessor.toBinarySignature(PanacheCompanion.class);
    static final String OBJECT_SIGNATURE = KotlinPanacheResourceProcessor.toBinarySignature(Object.class);
    static final String CLASS_SIGNATURE = KotlinPanacheResourceProcessor.toBinarySignature(Class.class);
    static final DotName TRANSIENT = DotName.createSimple((String)Transient.class.getName());
    static final Type CLASS_TYPE = Type.getType(Class.class);
    static final Type OBJECT_TYPE = Type.getType(Object.class);
    static final List<Type> REPOSITORY_TYPES = Arrays.asList(Type.getType(PanacheRepositoryBase.class), Type.getType(PanacheRepository.class));
    static final List<Type> ENTITY_TYPES = Arrays.asList(Type.getType(PanacheEntityBase.class), Type.getType(PanacheEntity.class), Type.getType(PanacheCompanion.class));

    static Type sanitize(Type[] argumentTypes) {
        Type primitiveReplaced = null;
        for (int i = 0; i < argumentTypes.length; ++i) {
            if (REPOSITORY_TYPES.contains(argumentTypes[i])) {
                argumentTypes[i] = CLASS_TYPE;
                continue;
            }
            if (ENTITY_TYPES.contains(argumentTypes[i])) {
                argumentTypes[i] = OBJECT_TYPE;
                continue;
            }
            if (argumentTypes[i].getInternalName().length() != 1) continue;
            primitiveReplaced = argumentTypes[i];
            argumentTypes[i] = OBJECT_TYPE;
        }
        return primitiveReplaced;
    }

    @NotNull
    static String toBinarySignature(Class<?> type) {
        return Type.getType(type).getDescriptor();
    }

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem(Feature.HIBERNATE_ORM_PANACHE_KOTLIN);
    }

    @BuildStep
    List<AdditionalJpaModelBuildItem> produceModel() {
        return Collections.singletonList(new AdditionalJpaModelBuildItem(PanacheEntity.class));
    }

    @BuildStep
    UnremovableBeanBuildItem ensureBeanLookupAvailable() {
        return new UnremovableBeanBuildItem((Predicate)new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo beanInfo) {
                for (org.jboss.jandex.Type t : beanInfo.getTypes()) {
                    if (!UNREMOVABLE_BEANS.contains(t.name())) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void build(PanacheKotlinHibernateOrmRecorder recorder, CombinedIndexBuildItem index, ApplicationIndexBuildItem applicationIndex, BuildProducer<BytecodeTransformerBuildItem> transformers, HibernateEnhancersRegisteredBuildItem hibernateMarker, List<PanacheMethodCustomizerBuildItem> methodCustomizersBuildItems, Optional<JpaModelPersistenceUnitMappingBuildItem> jpaModelPersistenceUnitMapping) {
        Object className;
        List typeParameters;
        List<PanacheMethodCustomizer> methodCustomizers = methodCustomizersBuildItems.stream().map(bi -> bi.getMethodCustomizer()).collect(Collectors.toList());
        KotlinPanacheRepositoryEnhancer daoEnhancer = new KotlinPanacheRepositoryEnhancer(index.getIndex());
        HashSet<String> daoClasses = new HashSet<String>();
        HashSet<String> panacheEntities = new HashSet<String>();
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(PANACHE_REPOSITORY_BASE)) {
            if (classInfo.name().equals((Object)PANACHE_REPOSITORY) || daoEnhancer.skipRepository(classInfo)) continue;
            typeParameters = JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)PANACHE_REPOSITORY_BASE, (IndexView)index.getIndex());
            panacheEntities.add(((org.jboss.jandex.Type)typeParameters.get(0)).name().toString());
            daoClasses.add(classInfo.name().toString());
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(PANACHE_REPOSITORY)) {
            if (daoEnhancer.skipRepository(classInfo)) continue;
            typeParameters = JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)PANACHE_REPOSITORY, (IndexView)index.getIndex());
            panacheEntities.add(((org.jboss.jandex.Type)typeParameters.get(0)).name().toString());
            daoClasses.add(classInfo.name().toString());
        }
        for (String daoClass : daoClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(daoClass, (BiFunction)((Object)daoEnhancer)));
        }
        KotlinPanacheCompanionEnhancer companionEnhancer = new KotlinPanacheCompanionEnhancer(index.getIndex(), methodCustomizers);
        KotlinPanacheEntityEnhancer entityEnhancer = new KotlinPanacheEntityEnhancer(index.getIndex(), methodCustomizers);
        HashSet<String> modelClasses = new HashSet<String>();
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(PANACHE_COMPANION)) {
            if (classInfo.name().equals((Object)PANACHE_ENTITY) || !modelClasses.add((String)(className = classInfo.name().toString()))) continue;
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem((String)className, (BiFunction)((Object)companionEnhancer)));
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(PANACHE_ENTITY_BASE)) {
            if (classInfo.name().equals((Object)PANACHE_ENTITY) || !modelClasses.add((String)(className = classInfo.name().toString()))) continue;
            entityEnhancer.collectFields(classInfo);
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem((String)className, (BiFunction)((Object)entityEnhancer)));
        }
        MetamodelInfo modelInfo = entityEnhancer.getModelInfo();
        if (modelInfo.hasEntities()) {
            PanacheFieldAccessEnhancer panacheFieldAccessEnhancer = new PanacheFieldAccessEnhancer(modelInfo);
            for (ClassInfo classInfo : applicationIndex.getIndex().getKnownClasses()) {
                String className2 = classInfo.name().toString();
                if (modelClasses.contains(className2)) continue;
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(className2, (BiFunction)panacheFieldAccessEnhancer));
            }
        }
        HashMap panacheEntityToPersistenceUnit = new HashMap();
        panacheEntities.addAll(modelClasses);
        if (jpaModelPersistenceUnitMapping.isPresent()) {
            Map collectedEntityToPersistenceUnits = jpaModelPersistenceUnitMapping.get().getEntityToPersistenceUnits();
            TreeMap<String, Set> violatingPanacheEntities = new TreeMap<String, Set>();
            for (Map.Entry iterator : collectedEntityToPersistenceUnits.entrySet()) {
                String entityName = (String)iterator.getKey();
                Set selectedPersistenceUnits = (Set)iterator.getValue();
                boolean isPanacheEntity = panacheEntities.stream().anyMatch(name -> name.equals(entityName));
                if (!isPanacheEntity) continue;
                if (selectedPersistenceUnits.size() == 1) {
                    panacheEntityToPersistenceUnit.put(entityName, selectedPersistenceUnits.iterator().next());
                    continue;
                }
                violatingPanacheEntities.put(entityName, selectedPersistenceUnits);
            }
            if (violatingPanacheEntities.size() > 0) {
                StringBuilder message = new StringBuilder("Panache entities do not support being attached to several persistence units:\n");
                Iterator iterator = violatingPanacheEntities.entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry violatingEntityEntry = iterator.next();
                    message.append("\t- ").append((String)violatingEntityEntry.getKey()).append(" is attached to: ").append(String.join((CharSequence)",", (Iterable)violatingEntityEntry.getValue()));
                    throw new IllegalStateException(message.toString());
                }
            }
        }
        recorder.setEntityToPersistenceUnit(panacheEntityToPersistenceUnit);
    }
}

