/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elasticsearch.restclient.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.UnsupportedSchemeException;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.util.Args;
import org.elasticsearch.client.Node;

@TargetClass(className="org.elasticsearch.client.RestClient")
final class Substitute_RestClient {
    @Alias
    private ConcurrentMap<HttpHost, DeadHostState> blacklist;
    @Alias
    private volatile NodeTuple<List<Node>> nodeTuple;

    Substitute_RestClient() {
    }

    @Substitute
    public synchronized void setNodes(Collection<Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("nodes must not be null or empty");
        }
        NoSerializationBasicAuthCache authCache = new NoSerializationBasicAuthCache();
        LinkedHashMap<HttpHost, Node> nodesByHost = new LinkedHashMap<HttpHost, Node>();
        for (Node node : nodes) {
            Objects.requireNonNull(node, "node cannot be null");
            nodesByHost.put(node.getHost(), node);
            authCache.put(node.getHost(), (AuthScheme)new BasicScheme());
        }
        this.nodeTuple = new NodeTuple(Collections.unmodifiableList(new ArrayList(nodesByHost.values())), authCache);
        this.blacklist.clear();
    }

    @Contract(threading=ThreadingBehavior.SAFE)
    private static final class NoSerializationBasicAuthCache
    implements AuthCache {
        private final Map<HttpHost, AuthScheme> map = new ConcurrentHashMap<HttpHost, AuthScheme>();
        private final SchemePortResolver schemePortResolver;

        public NoSerializationBasicAuthCache(SchemePortResolver schemePortResolver) {
            this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        }

        public NoSerializationBasicAuthCache() {
            this(null);
        }

        protected HttpHost getKey(HttpHost host) {
            if (host.getPort() <= 0) {
                int port;
                try {
                    port = this.schemePortResolver.resolve(host);
                }
                catch (UnsupportedSchemeException ignore) {
                    return host;
                }
                return new HttpHost(host.getHostName(), port, host.getSchemeName());
            }
            return host;
        }

        public void put(HttpHost host, AuthScheme authScheme) {
            Args.notNull((Object)host, (String)"HTTP host");
            if (authScheme == null) {
                return;
            }
            this.map.put(this.getKey(host), authScheme);
        }

        public AuthScheme get(HttpHost host) {
            Args.notNull((Object)host, (String)"HTTP host");
            return this.map.get(this.getKey(host));
        }

        public void remove(HttpHost host) {
            Args.notNull((Object)host, (String)"HTTP host");
            this.map.remove(this.getKey(host));
        }

        public void clear() {
            this.map.clear();
        }

        public String toString() {
            return this.map.toString();
        }
    }

    @TargetClass(className="org.elasticsearch.client.RestClient", innerClass={"NodeTuple"})
    static final class NodeTuple<T> {
        @Alias
        NodeTuple(T nodes, AuthCache authCache) {
        }
    }

    @TargetClass(className="org.elasticsearch.client.DeadHostState")
    static final class DeadHostState {
        DeadHostState() {
        }
    }
}

