/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.mongo;

import in.erail.glue.annotation.StartService;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.ext.mongo.MongoClient;
import java.util.Set;

public class LoadMongoDataService {
    private MongoClient mMongoClient;
    private JsonObject mData;
    private boolean mEnable;

    @StartService
    public void start() {
        if (!this.isEnable()) {
            return;
        }
        Set collections = this.mData.fieldNames();
        for (String collection : collections) {
            this.mMongoClient.rxDropCollection(collection).andThen((CompletableSource)this.mMongoClient.rxCreateCollection(collection)).blockingAwait();
            JsonArray data = this.mData.getJsonArray(collection);
            Observable.fromIterable((Iterable)data).map(m -> (JsonObject)m).doOnNext(t -> this.mMongoClient.rxSave(collection, t).blockingGet()).blockingSubscribe();
        }
    }

    public MongoClient getMongoClient() {
        return this.mMongoClient;
    }

    public void setMongoClient(MongoClient pMongoClient) {
        this.mMongoClient = pMongoClient;
    }

    public JsonObject getData() {
        return this.mData;
    }

    public void setData(JsonObject pData) {
        this.mData = pData;
    }

    public boolean isEnable() {
        return this.mEnable;
    }

    public void setEnable(boolean pEnable) {
        this.mEnable = pEnable;
    }
}

