/*
 * Decompiled with CFR 0.152.
 */
package in.erail.route;

import com.google.common.base.Strings;
import in.erail.route.AbstractRouterBuilderImpl;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2TokenImpl;
import io.vertx.reactivex.ext.auth.User;
import io.vertx.reactivex.ext.auth.oauth2.AccessToken;
import io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth;
import io.vertx.reactivex.ext.web.Router;
import io.vertx.reactivex.ext.web.RoutingContext;

public class LoadUserFromAccessTokenRouteBuillder
extends AbstractRouterBuilderImpl {
    private OAuth2Auth mOAuth2Auth;

    public OAuth2Auth getOAuth2Auth() {
        return this.mOAuth2Auth;
    }

    public void setOAuth2Auth(OAuth2Auth pOAuth2Auth) {
        this.mOAuth2Auth = pOAuth2Auth;
    }

    @Override
    public Router getRouter(Router pRouter) {
        pRouter.route().handler(this::handle);
        return pRouter;
    }

    public void handle(RoutingContext pRoutingContext) {
        String access_token;
        if (pRoutingContext.user() == null && !Strings.isNullOrEmpty((String)(access_token = pRoutingContext.request().getHeader("Authorization")))) {
            OAuth2AuthProviderImpl provider = (OAuth2AuthProviderImpl)this.getOAuth2Auth().getDelegate();
            JsonObject accessToken = new JsonObject().put("access_token", access_token.split(" ")[1]);
            try {
                OAuth2TokenImpl token = new OAuth2TokenImpl(provider, accessToken);
                pRoutingContext.setUser((User)new AccessToken((io.vertx.ext.auth.oauth2.AccessToken)token));
            }
            catch (RuntimeException e) {
                this.getLog().error((Object)e);
                pRoutingContext.fail(401);
                return;
            }
        }
        pRoutingContext.next();
    }
}

