/*
 * Decompiled with CFR 0.152.
 */
package in.erail.server;

import in.erail.glue.Glue;
import in.erail.glue.annotation.StartService;
import in.erail.route.RouterBuilder;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.http.HttpServer;
import io.vertx.reactivex.ext.web.Router;
import io.vertx.reactivex.ext.web.handler.LoggerHandler;
import io.vertx.reactivex.ext.web.handler.sockjs.SockJSHandler;
import org.apache.logging.log4j.Logger;

public class Server {
    private Vertx mVertx;
    private String[] mRouterBuilder;
    private String[] mMountPath;
    private Router[] mRouter;
    private Logger mLog;
    private SockJSHandler mSockJSHandler;
    private HttpServerOptions mHttpServerOptions;

    @StartService
    public void start() {
        HttpServer server = this.getVertx().createHttpServer(this.getHttpServerOptions());
        Router router = Router.router((Vertx)this.getVertx());
        if (this.getLog().isDebugEnabled()) {
            router.route("/*").handler((Handler)LoggerHandler.create());
        }
        if (this.getSockJSHandler() != null) {
            router.route("/eventbus/*").handler((Handler)this.getSockJSHandler());
        }
        for (int i = 0; i < this.mMountPath.length; ++i) {
            router.mountSubRouter(this.mMountPath[i], this.mRouter[i]);
        }
        server.requestHandler(arg_0 -> ((Router)router).accept(arg_0)).rxListen().blockingGet();
        this.getLog().debug(() -> String.format("---------------Server[%s:%s] is ready-----------------", this.getHttpServerOptions().getHost(), this.getHttpServerOptions().getPort()));
    }

    public Vertx getVertx() {
        return this.mVertx;
    }

    public void setVertx(Vertx pVertx) {
        this.mVertx = pVertx;
    }

    public String[] getRouterBuilder() {
        return this.mRouterBuilder;
    }

    public void setRouterBuilder(String[] pRouterBuilder) {
        this.mRouterBuilder = pRouterBuilder;
        this.mMountPath = new String[pRouterBuilder.length];
        this.mRouter = new Router[pRouterBuilder.length];
        for (int i = 0; i < pRouterBuilder.length; ++i) {
            String route;
            String[] kv = pRouterBuilder[i].split("=");
            Object component = Glue.instance().resolve(kv[1]);
            this.mMountPath[i] = route = kv[0];
            this.mRouter[i] = ((RouterBuilder)component).getRouter();
        }
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }

    public SockJSHandler getSockJSHandler() {
        return this.mSockJSHandler;
    }

    public void setSockJSHandler(SockJSHandler pSockJSHandler) {
        this.mSockJSHandler = pSockJSHandler;
    }

    public HttpServerOptions getHttpServerOptions() {
        return this.mHttpServerOptions;
    }

    public void setHttpServerOptions(HttpServerOptions pHttpServerOptions) {
        this.mHttpServerOptions = pHttpServerOptions;
    }
}

