/*
 * Decompiled with CFR 0.152.
 */
package in.erail.amazon.lambda.eventsource;

import com.google.common.net.MediaType;
import in.erail.amazon.lambda.EventSource;
import in.erail.amazon.lambda.eventsource.EventSourceName;
import in.erail.glue.common.Util;
import io.vertx.core.json.JsonObject;

public class SESEventSource
implements EventSource {
    public static final String URL = "/aws/ses";
    public static final String ENV_NAME = "api.framework.lambda.ses.url";
    private final String url = Util.getEnvironmentValue((String)"api.framework.lambda.ses.url", (String)"/aws/ses");

    @Override
    public EventSourceName getEventSourceName() {
        return EventSourceName.SES;
    }

    @Override
    public JsonObject transform(JsonObject pEvent) {
        JsonObject newRequest = new JsonObject().put("path", this.url).put("httpMethod", "POST").put("body", pEvent.toString().getBytes()).put("headers", new JsonObject().put("Content-Type", MediaType.JSON_UTF_8.toString()).put("aws-event-source", this.getEventSourceName().toString()));
        return newRequest;
    }
}

